/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.knox.gateway.model.DescriptorConfiguration;
import org.apache.knox.gateway.model.Topology;
import org.apache.knox.gateway.util.ServiceUrls;

public class DescriptorGenerator {
    private static final ObjectMapper mapper = new ObjectMapper();
    private final String descriptorName;
    private final String providerName;
    private final String serviceName;
    private final ServiceUrls serviceUrls;
    private final Map<String, String> params;

    public DescriptorGenerator(String descriptorName, String providerName, String serviceName, ServiceUrls serviceUrls, Map<String, String> params) {
        this.descriptorName = descriptorName;
        this.providerName = providerName;
        this.serviceName = serviceName.toUpperCase(Locale.ROOT);
        this.serviceUrls = serviceUrls;
        this.params = params;
    }

    public void saveDescriptor(File outputDir, boolean forceOverwrite) {
        File outputFile = new File(outputDir, this.descriptorName);
        if (outputFile.exists() && !forceOverwrite) {
            throw new IllegalArgumentException(outputFile + " already exists");
        }
        DescriptorConfiguration descriptor = new DescriptorConfiguration();
        descriptor.setName(FilenameUtils.removeExtension((String)this.descriptorName));
        descriptor.setProviderConfig(FilenameUtils.removeExtension((String)this.providerName));
        Topology.Service service = new Topology.Service();
        service.setRole(this.serviceName);
        service.setUrls(this.serviceUrls.toList());
        this.setParams(service, this.params);
        descriptor.setServices(Arrays.asList(service));
        try {
            mapper.writerWithDefaultPrettyPrinter().writeValue(outputFile, (Object)descriptor);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void setParams(Topology.Service service, Map<String, String> params) {
        ArrayList<Topology.Param> paramList = new ArrayList<Topology.Param>();
        for (Map.Entry<String, String> each : params.entrySet()) {
            paramList.add(new Topology.Param(each.getKey(), each.getValue()));
        }
        service.setParams(paramList);
    }

    static {
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

