/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Arguments used to install a Private Cloud Control Plane on embedded kubernetes")
public class ApiInstallEmbeddedControlPlaneArgs {
    @SerializedName(value="remoteRepoUrl")
    private String remoteRepoUrl = null;
    @SerializedName(value="valuesYaml")
    private String valuesYaml = null;
    @SerializedName(value="experienceClusterName")
    private String experienceClusterName = null;
    @SerializedName(value="containerizedClusterName")
    private String containerizedClusterName = null;
    @SerializedName(value="datalakeClusterName")
    private String datalakeClusterName = null;
    @SerializedName(value="selectedFeatures")
    private String selectedFeatures = null;

    public ApiInstallEmbeddedControlPlaneArgs remoteRepoUrl(String remoteRepoUrl) {
        this.remoteRepoUrl = remoteRepoUrl;
        return this;
    }

    @ApiModelProperty(value="The url of the remote repository where the private cloud artifacts to install are hosted")
    public String getRemoteRepoUrl() {
        return this.remoteRepoUrl;
    }

    public void setRemoteRepoUrl(String remoteRepoUrl) {
        this.remoteRepoUrl = remoteRepoUrl;
    }

    public ApiInstallEmbeddedControlPlaneArgs valuesYaml(String valuesYaml) {
        this.valuesYaml = valuesYaml;
        return this;
    }

    @ApiModelProperty(value="A yaml file containing configuration parameters for the installation.")
    public String getValuesYaml() {
        return this.valuesYaml;
    }

    public void setValuesYaml(String valuesYaml) {
        this.valuesYaml = valuesYaml;
    }

    public ApiInstallEmbeddedControlPlaneArgs experienceClusterName(String experienceClusterName) {
        this.experienceClusterName = experienceClusterName;
        return this;
    }

    @ApiModelProperty(value="Deprecated. Use containerizedClusterName instead.")
    public String getExperienceClusterName() {
        return this.experienceClusterName;
    }

    public void setExperienceClusterName(String experienceClusterName) {
        this.experienceClusterName = experienceClusterName;
    }

    public ApiInstallEmbeddedControlPlaneArgs containerizedClusterName(String containerizedClusterName) {
        this.containerizedClusterName = containerizedClusterName;
        return this;
    }

    @ApiModelProperty(value="The name of the Containerized Cluster that will bring up this control plane")
    public String getContainerizedClusterName() {
        return this.containerizedClusterName;
    }

    public void setContainerizedClusterName(String containerizedClusterName) {
        this.containerizedClusterName = containerizedClusterName;
    }

    public ApiInstallEmbeddedControlPlaneArgs datalakeClusterName(String datalakeClusterName) {
        this.datalakeClusterName = datalakeClusterName;
        return this;
    }

    @ApiModelProperty(value="The name of the datalake cluster to use for the initial environment in this control plane")
    public String getDatalakeClusterName() {
        return this.datalakeClusterName;
    }

    public void setDatalakeClusterName(String datalakeClusterName) {
        this.datalakeClusterName = datalakeClusterName;
    }

    public ApiInstallEmbeddedControlPlaneArgs selectedFeatures(String selectedFeatures) {
        this.selectedFeatures = selectedFeatures;
        return this;
    }

    @ApiModelProperty(value="Optional. The name of the feature(s) in a comma separated list that container images/packages are associated with. When it is null, copy all the images.")
    public String getSelectedFeatures() {
        return this.selectedFeatures;
    }

    public void setSelectedFeatures(String selectedFeatures) {
        this.selectedFeatures = selectedFeatures;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiInstallEmbeddedControlPlaneArgs apiInstallEmbeddedControlPlaneArgs = (ApiInstallEmbeddedControlPlaneArgs)o;
        return Objects.equals(this.remoteRepoUrl, apiInstallEmbeddedControlPlaneArgs.remoteRepoUrl) && Objects.equals(this.valuesYaml, apiInstallEmbeddedControlPlaneArgs.valuesYaml) && Objects.equals(this.experienceClusterName, apiInstallEmbeddedControlPlaneArgs.experienceClusterName) && Objects.equals(this.containerizedClusterName, apiInstallEmbeddedControlPlaneArgs.containerizedClusterName) && Objects.equals(this.datalakeClusterName, apiInstallEmbeddedControlPlaneArgs.datalakeClusterName) && Objects.equals(this.selectedFeatures, apiInstallEmbeddedControlPlaneArgs.selectedFeatures);
    }

    public int hashCode() {
        return Objects.hash(this.remoteRepoUrl, this.valuesYaml, this.experienceClusterName, this.containerizedClusterName, this.datalakeClusterName, this.selectedFeatures);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiInstallEmbeddedControlPlaneArgs {\n");
        sb.append("    remoteRepoUrl: ").append(this.toIndentedString(this.remoteRepoUrl)).append("\n");
        sb.append("    valuesYaml: ").append(this.toIndentedString(this.valuesYaml)).append("\n");
        sb.append("    experienceClusterName: ").append(this.toIndentedString(this.experienceClusterName)).append("\n");
        sb.append("    containerizedClusterName: ").append(this.toIndentedString(this.containerizedClusterName)).append("\n");
        sb.append("    datalakeClusterName: ").append(this.toIndentedString(this.datalakeClusterName)).append("\n");
        sb.append("    selectedFeatures: ").append(this.toIndentedString(this.selectedFeatures)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

