/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Models audit events from both CM and CM managed services like HDFS, HBase and Hive. Audits for CM managed services are retrieved from Cloudera Navigator server.")
public class ApiAudit {
    @SerializedName(value="timestamp")
    private String timestamp = null;
    @SerializedName(value="service")
    private String service = null;
    @SerializedName(value="username")
    private String username = null;
    @SerializedName(value="impersonator")
    private String impersonator = null;
    @SerializedName(value="ipAddress")
    private String ipAddress = null;
    @SerializedName(value="command")
    private String command = null;
    @SerializedName(value="resource")
    private String resource = null;
    @SerializedName(value="operationText")
    private String operationText = null;
    @SerializedName(value="allowed")
    private Boolean allowed = null;
    @SerializedName(value="serviceValues")
    private Map<String, String> serviceValues = null;

    public ApiAudit timestamp(String timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @ApiModelProperty(value="When the audit event was captured.")
    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public ApiAudit service(String service) {
        this.service = service;
        return this;
    }

    @ApiModelProperty(value="Service name associated with this audit.")
    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public ApiAudit username(String username) {
        this.username = username;
        return this;
    }

    @ApiModelProperty(value="The user who performed this operation.")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public ApiAudit impersonator(String impersonator) {
        this.impersonator = impersonator;
        return this;
    }

    @ApiModelProperty(value="The impersonating user (or the proxy user) who submitted this operation. This is usually applicable when using services like Oozie or Hue, who can be configured to impersonate other users and submit jobs.")
    public String getImpersonator() {
        return this.impersonator;
    }

    public void setImpersonator(String impersonator) {
        this.impersonator = impersonator;
    }

    public ApiAudit ipAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    @ApiModelProperty(value="The IP address that the client connected from.")
    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public ApiAudit command(String command) {
        this.command = command;
        return this;
    }

    @ApiModelProperty(value="The command/operation that was requested.")
    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public ApiAudit resource(String resource) {
        this.resource = resource;
        return this;
    }

    @ApiModelProperty(value="The resource that the operation was performed on.")
    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public ApiAudit operationText(String operationText) {
        this.operationText = operationText;
        return this;
    }

    @ApiModelProperty(value="The full text of the requested operation. E.g. the full Hive query. <p> Available since API v5.")
    public String getOperationText() {
        return this.operationText;
    }

    public void setOperationText(String operationText) {
        this.operationText = operationText;
    }

    public ApiAudit allowed(Boolean allowed) {
        this.allowed = allowed;
        return this;
    }

    @ApiModelProperty(value="Whether the operation was allowed or denied by the authorization system.")
    public Boolean getAllowed() {
        return this.allowed;
    }

    public void setAllowed(Boolean allowed) {
        this.allowed = allowed;
    }

    public ApiAudit serviceValues(Map<String, String> serviceValues) {
        this.serviceValues = serviceValues;
        return this;
    }

    public ApiAudit putServiceValuesItem(String key, String serviceValuesItem) {
        if (this.serviceValues == null) {
            this.serviceValues = new HashMap<String, String>();
        }
        this.serviceValues.put(key, serviceValuesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public Map<String, String> getServiceValues() {
        return this.serviceValues;
    }

    public void setServiceValues(Map<String, String> serviceValues) {
        this.serviceValues = serviceValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiAudit apiAudit = (ApiAudit)o;
        return Objects.equals(this.timestamp, apiAudit.timestamp) && Objects.equals(this.service, apiAudit.service) && Objects.equals(this.username, apiAudit.username) && Objects.equals(this.impersonator, apiAudit.impersonator) && Objects.equals(this.ipAddress, apiAudit.ipAddress) && Objects.equals(this.command, apiAudit.command) && Objects.equals(this.resource, apiAudit.resource) && Objects.equals(this.operationText, apiAudit.operationText) && Objects.equals(this.allowed, apiAudit.allowed) && Objects.equals(this.serviceValues, apiAudit.serviceValues);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.service, this.username, this.impersonator, this.ipAddress, this.command, this.resource, this.operationText, this.allowed, this.serviceValues);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiAudit {\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    service: ").append(this.toIndentedString(this.service)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("    impersonator: ").append(this.toIndentedString(this.impersonator)).append("\n");
        sb.append("    ipAddress: ").append(this.toIndentedString(this.ipAddress)).append("\n");
        sb.append("    command: ").append(this.toIndentedString(this.command)).append("\n");
        sb.append("    resource: ").append(this.toIndentedString(this.resource)).append("\n");
        sb.append("    operationText: ").append(this.toIndentedString(this.operationText)).append("\n");
        sb.append("    allowed: ").append(this.toIndentedString(this.allowed)).append("\n");
        sb.append("    serviceValues: ").append(this.toIndentedString(this.serviceValues)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

