/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger;

import com.cloudera.api.swagger.client.ApiCallback;
import com.cloudera.api.swagger.client.ApiClient;
import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.client.ApiResponse;
import com.cloudera.api.swagger.client.Configuration;
import com.cloudera.api.swagger.client.Pair;
import com.cloudera.api.swagger.client.ProgressRequestBody;
import com.cloudera.api.swagger.client.ProgressResponseBody;
import com.cloudera.api.swagger.model.ApiActivity;
import com.cloudera.api.swagger.model.ApiActivityList;
import com.cloudera.api.swagger.model.ApiMetricList;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ActivitiesResourceApi {
    private ApiClient apiClient;

    public ActivitiesResourceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ActivitiesResourceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getMetricsCall(String activityId, String clusterName, String serviceName, String from, List<String> metrics, String to, String view, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/activities/{activityId}/metrics".replaceAll("\\{activityId\\}", this.apiClient.escapeString(activityId.toString())).replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (from != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "from", from));
        }
        if (metrics != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "metrics", metrics));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "to", to));
        }
        if (view != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "view", view));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getMetricsValidateBeforeCall(String activityId, String clusterName, String serviceName, String from, List<String> metrics, String to, String view, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (activityId == null) {
            throw new ApiException("Missing the required parameter 'activityId' when calling getMetrics(Async)");
        }
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling getMetrics(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling getMetrics(Async)");
        }
        Call call = this.getMetricsCall(activityId, clusterName, serviceName, from, metrics, to, view, progressListener, progressRequestListener);
        return call;
    }

    public ApiMetricList getMetrics(String activityId, String clusterName, String serviceName, String from, List<String> metrics, String to, String view) throws ApiException {
        ApiResponse<ApiMetricList> resp = this.getMetricsWithHttpInfo(activityId, clusterName, serviceName, from, metrics, to, view);
        return resp.getData();
    }

    public ApiResponse<ApiMetricList> getMetricsWithHttpInfo(String activityId, String clusterName, String serviceName, String from, List<String> metrics, String to, String view) throws ApiException {
        Call call = this.getMetricsValidateBeforeCall(activityId, clusterName, serviceName, from, metrics, to, view, null, null);
        Type localVarReturnType = new TypeToken<ApiMetricList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getMetricsAsync(String activityId, String clusterName, String serviceName, String from, List<String> metrics, String to, String view, final ApiCallback<ApiMetricList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getMetricsValidateBeforeCall(activityId, clusterName, serviceName, from, metrics, to, view, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiMetricList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call readActivitiesCall(String clusterName, String serviceName, BigDecimal maxResults, String query, BigDecimal resultOffset, String view, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/activities".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (maxResults != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "maxResults", maxResults));
        }
        if (query != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "query", query));
        }
        if (resultOffset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "resultOffset", resultOffset));
        }
        if (view != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "view", view));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call readActivitiesValidateBeforeCall(String clusterName, String serviceName, BigDecimal maxResults, String query, BigDecimal resultOffset, String view, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling readActivities(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling readActivities(Async)");
        }
        Call call = this.readActivitiesCall(clusterName, serviceName, maxResults, query, resultOffset, view, progressListener, progressRequestListener);
        return call;
    }

    public ApiActivityList readActivities(String clusterName, String serviceName, BigDecimal maxResults, String query, BigDecimal resultOffset, String view) throws ApiException {
        ApiResponse<ApiActivityList> resp = this.readActivitiesWithHttpInfo(clusterName, serviceName, maxResults, query, resultOffset, view);
        return resp.getData();
    }

    public ApiResponse<ApiActivityList> readActivitiesWithHttpInfo(String clusterName, String serviceName, BigDecimal maxResults, String query, BigDecimal resultOffset, String view) throws ApiException {
        Call call = this.readActivitiesValidateBeforeCall(clusterName, serviceName, maxResults, query, resultOffset, view, null, null);
        Type localVarReturnType = new TypeToken<ApiActivityList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call readActivitiesAsync(String clusterName, String serviceName, BigDecimal maxResults, String query, BigDecimal resultOffset, String view, final ApiCallback<ApiActivityList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.readActivitiesValidateBeforeCall(clusterName, serviceName, maxResults, query, resultOffset, view, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiActivityList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call readActivityCall(String activityId, String clusterName, String serviceName, String view, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/activities/{activityId}".replaceAll("\\{activityId\\}", this.apiClient.escapeString(activityId.toString())).replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (view != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "view", view));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call readActivityValidateBeforeCall(String activityId, String clusterName, String serviceName, String view, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (activityId == null) {
            throw new ApiException("Missing the required parameter 'activityId' when calling readActivity(Async)");
        }
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling readActivity(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling readActivity(Async)");
        }
        Call call = this.readActivityCall(activityId, clusterName, serviceName, view, progressListener, progressRequestListener);
        return call;
    }

    public ApiActivity readActivity(String activityId, String clusterName, String serviceName, String view) throws ApiException {
        ApiResponse<ApiActivity> resp = this.readActivityWithHttpInfo(activityId, clusterName, serviceName, view);
        return resp.getData();
    }

    public ApiResponse<ApiActivity> readActivityWithHttpInfo(String activityId, String clusterName, String serviceName, String view) throws ApiException {
        Call call = this.readActivityValidateBeforeCall(activityId, clusterName, serviceName, view, null, null);
        Type localVarReturnType = new TypeToken<ApiActivity>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call readActivityAsync(String activityId, String clusterName, String serviceName, String view, final ApiCallback<ApiActivity> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.readActivityValidateBeforeCall(activityId, clusterName, serviceName, view, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiActivity>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call readChildActivitiesCall(String activityId, String clusterName, String serviceName, BigDecimal maxResults, BigDecimal resultOffset, String view, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/activities/{activityId}/children".replaceAll("\\{activityId\\}", this.apiClient.escapeString(activityId.toString())).replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (maxResults != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "maxResults", maxResults));
        }
        if (resultOffset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "resultOffset", resultOffset));
        }
        if (view != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "view", view));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call readChildActivitiesValidateBeforeCall(String activityId, String clusterName, String serviceName, BigDecimal maxResults, BigDecimal resultOffset, String view, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (activityId == null) {
            throw new ApiException("Missing the required parameter 'activityId' when calling readChildActivities(Async)");
        }
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling readChildActivities(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling readChildActivities(Async)");
        }
        Call call = this.readChildActivitiesCall(activityId, clusterName, serviceName, maxResults, resultOffset, view, progressListener, progressRequestListener);
        return call;
    }

    public ApiActivityList readChildActivities(String activityId, String clusterName, String serviceName, BigDecimal maxResults, BigDecimal resultOffset, String view) throws ApiException {
        ApiResponse<ApiActivityList> resp = this.readChildActivitiesWithHttpInfo(activityId, clusterName, serviceName, maxResults, resultOffset, view);
        return resp.getData();
    }

    public ApiResponse<ApiActivityList> readChildActivitiesWithHttpInfo(String activityId, String clusterName, String serviceName, BigDecimal maxResults, BigDecimal resultOffset, String view) throws ApiException {
        Call call = this.readChildActivitiesValidateBeforeCall(activityId, clusterName, serviceName, maxResults, resultOffset, view, null, null);
        Type localVarReturnType = new TypeToken<ApiActivityList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call readChildActivitiesAsync(String activityId, String clusterName, String serviceName, BigDecimal maxResults, BigDecimal resultOffset, String view, final ApiCallback<ApiActivityList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.readChildActivitiesValidateBeforeCall(activityId, clusterName, serviceName, maxResults, resultOffset, view, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiActivityList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call readSimilarActivitiesCall(String activityId, String clusterName, String serviceName, String view, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/activities/{activityId}/similar".replaceAll("\\{activityId\\}", this.apiClient.escapeString(activityId.toString())).replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (view != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "view", view));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call readSimilarActivitiesValidateBeforeCall(String activityId, String clusterName, String serviceName, String view, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (activityId == null) {
            throw new ApiException("Missing the required parameter 'activityId' when calling readSimilarActivities(Async)");
        }
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling readSimilarActivities(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling readSimilarActivities(Async)");
        }
        Call call = this.readSimilarActivitiesCall(activityId, clusterName, serviceName, view, progressListener, progressRequestListener);
        return call;
    }

    public ApiActivityList readSimilarActivities(String activityId, String clusterName, String serviceName, String view) throws ApiException {
        ApiResponse<ApiActivityList> resp = this.readSimilarActivitiesWithHttpInfo(activityId, clusterName, serviceName, view);
        return resp.getData();
    }

    public ApiResponse<ApiActivityList> readSimilarActivitiesWithHttpInfo(String activityId, String clusterName, String serviceName, String view) throws ApiException {
        Call call = this.readSimilarActivitiesValidateBeforeCall(activityId, clusterName, serviceName, view, null, null);
        Type localVarReturnType = new TypeToken<ApiActivityList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call readSimilarActivitiesAsync(String activityId, String clusterName, String serviceName, String view, final ApiCallback<ApiActivityList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.readSimilarActivitiesValidateBeforeCall(activityId, clusterName, serviceName, view, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiActivityList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

