/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import jersey.repackaged.com.google.common.base.Objects;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.message.internal.OutboundMessageContext;
import org.glassfish.jersey.message.internal.Statuses;

public class OutboundJaxrsResponse
extends Response {
    private final OutboundMessageContext context;
    private final Response.StatusType status;
    private boolean closed = false;
    private boolean buffered = false;

    public static OutboundJaxrsResponse from(Response response) {
        if (response instanceof OutboundJaxrsResponse) {
            return (OutboundJaxrsResponse)response;
        }
        Response.StatusType status = response.getStatusInfo();
        OutboundMessageContext context = new OutboundMessageContext();
        context.getHeaders().putAll((Map)response.getMetadata());
        context.setEntity(response.getEntity());
        return new OutboundJaxrsResponse(status, context);
    }

    public OutboundJaxrsResponse(Response.StatusType status, OutboundMessageContext context) {
        this.status = status;
        this.context = context;
    }

    public OutboundMessageContext getContext() {
        return this.context;
    }

    public int getStatus() {
        return this.status.getStatusCode();
    }

    public Response.StatusType getStatusInfo() {
        return this.status;
    }

    public Object getEntity() {
        if (this.closed) {
            throw new IllegalStateException(LocalizationMessages.RESPONSE_CLOSED());
        }
        return this.context.getEntity();
    }

    public <T> T readEntity(Class<T> type) throws ProcessingException {
        throw new IllegalStateException(LocalizationMessages.NOT_SUPPORTED_ON_OUTBOUND_MESSAGE());
    }

    public <T> T readEntity(GenericType<T> entityType) throws ProcessingException {
        throw new IllegalStateException(LocalizationMessages.NOT_SUPPORTED_ON_OUTBOUND_MESSAGE());
    }

    public <T> T readEntity(Class<T> type, Annotation[] annotations) throws ProcessingException {
        throw new IllegalStateException(LocalizationMessages.NOT_SUPPORTED_ON_OUTBOUND_MESSAGE());
    }

    public <T> T readEntity(GenericType<T> entityType, Annotation[] annotations) throws ProcessingException {
        throw new IllegalStateException(LocalizationMessages.NOT_SUPPORTED_ON_OUTBOUND_MESSAGE());
    }

    public boolean hasEntity() {
        if (this.closed) {
            throw new IllegalStateException(LocalizationMessages.RESPONSE_CLOSED());
        }
        return this.context.hasEntity();
    }

    public boolean bufferEntity() throws ProcessingException {
        if (this.closed) {
            throw new IllegalStateException(LocalizationMessages.RESPONSE_CLOSED());
        }
        if (!this.context.hasEntity() || !InputStream.class.isAssignableFrom(this.context.getEntityClass())) {
            return false;
        }
        if (this.buffered) {
            return true;
        }
        InputStream in = (InputStream)InputStream.class.cast(this.context.getEntity());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int len;
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
        }
        catch (IOException ex) {
            throw new ProcessingException((Throwable)ex);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {
                throw new ProcessingException((Throwable)ex);
            }
        }
        this.context.setEntity(new ByteArrayInputStream(out.toByteArray()));
        this.buffered = true;
        return true;
    }

    public void close() throws ProcessingException {
        this.closed = true;
        this.context.close();
        if (this.buffered) {
            this.context.setEntity(null);
        } else if (this.context.hasEntity() && InputStream.class.isAssignableFrom(this.context.getEntityClass())) {
            try {
                ((InputStream)InputStream.class.cast(this.context.getEntity())).close();
            }
            catch (IOException ex) {
                throw new ProcessingException((Throwable)ex);
            }
        }
    }

    public MultivaluedMap<String, String> getStringHeaders() {
        return this.context.getStringHeaders();
    }

    public String getHeaderString(String name) {
        return this.context.getHeaderString(name);
    }

    public MediaType getMediaType() {
        return this.context.getMediaType();
    }

    public Locale getLanguage() {
        return this.context.getLanguage();
    }

    public int getLength() {
        return this.context.getLength();
    }

    public Map<String, NewCookie> getCookies() {
        return this.context.getResponseCookies();
    }

    public EntityTag getEntityTag() {
        return this.context.getEntityTag();
    }

    public Date getDate() {
        return this.context.getDate();
    }

    public Date getLastModified() {
        return this.context.getLastModified();
    }

    public Set<String> getAllowedMethods() {
        return this.context.getAllowedMethods();
    }

    public URI getLocation() {
        return this.context.getLocation();
    }

    public Set<Link> getLinks() {
        return this.context.getLinks();
    }

    public boolean hasLink(String relation) {
        return this.context.hasLink(relation);
    }

    public Link getLink(String relation) {
        return this.context.getLink(relation);
    }

    public Link.Builder getLinkBuilder(String relation) {
        return this.context.getLinkBuilder(relation);
    }

    public MultivaluedMap<String, Object> getMetadata() {
        return this.context.getHeaders();
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("status", this.status.getStatusCode()).add("reason", (Object)this.status.getReasonPhrase()).add("hasEntity", (Object)this.context.hasEntity()).add("closed", (Object)this.closed).add("buffered", (Object)this.buffered).toString();
    }

    public static class Builder
    extends Response.ResponseBuilder {
        private Response.StatusType status;
        private final OutboundMessageContext context;
        private static final InheritableThreadLocal<URI> baseUriThreadLocal = new InheritableThreadLocal();

        public static void setBaseUri(URI baseUri) {
            baseUriThreadLocal.set(baseUri);
        }

        private static URI getBaseUri() {
            return (URI)baseUriThreadLocal.get();
        }

        public static void clearBaseUri() {
            baseUriThreadLocal.remove();
        }

        public Builder(OutboundMessageContext context) {
            this.context = context;
        }

        public Response build() {
            Response.StatusType st = this.status;
            if (st == null) {
                st = this.context.hasEntity() ? Response.Status.OK : Response.Status.NO_CONTENT;
            }
            return new OutboundJaxrsResponse(st, new OutboundMessageContext(this.context));
        }

        public Response.ResponseBuilder clone() {
            return new Builder(new OutboundMessageContext(this.context)).status(this.status);
        }

        public Response.ResponseBuilder status(Response.StatusType status) {
            if (status == null) {
                throw new IllegalArgumentException("Response status must not be 'null'");
            }
            this.status = status;
            return this;
        }

        public Response.ResponseBuilder status(int code) {
            this.status = Statuses.from(code);
            return this;
        }

        public Response.ResponseBuilder entity(Object entity) {
            this.context.setEntity(entity);
            return this;
        }

        public Response.ResponseBuilder entity(Object entity, Annotation[] annotations) {
            this.context.setEntity(entity, annotations);
            return this;
        }

        public Response.ResponseBuilder type(MediaType type) {
            this.context.setMediaType(type);
            return this;
        }

        public Response.ResponseBuilder type(String type) {
            return this.type(type == null ? null : MediaType.valueOf((String)type));
        }

        public Response.ResponseBuilder variant(Variant variant) {
            if (variant == null) {
                this.type((MediaType)null);
                this.language((String)null);
                this.encoding(null);
                return this;
            }
            this.type(variant.getMediaType());
            this.language(variant.getLanguage());
            this.encoding(variant.getEncoding());
            return this;
        }

        public Response.ResponseBuilder variants(List<Variant> variants) {
            if (variants == null) {
                this.header("Vary", null);
                return this;
            }
            if (variants.isEmpty()) {
                return this;
            }
            MediaType accept = variants.get(0).getMediaType();
            boolean vAccept = false;
            Locale acceptLanguage = variants.get(0).getLanguage();
            boolean vAcceptLanguage = false;
            String acceptEncoding = variants.get(0).getEncoding();
            boolean vAcceptEncoding = false;
            for (Variant v : variants) {
                vAccept |= !vAccept && this.vary(v.getMediaType(), accept);
                vAcceptLanguage |= !vAcceptLanguage && this.vary(v.getLanguage(), acceptLanguage);
                vAcceptEncoding |= !vAcceptEncoding && this.vary(v.getEncoding(), acceptEncoding);
            }
            StringBuilder vary = new StringBuilder();
            this.append(vary, vAccept, "Accept");
            this.append(vary, vAcceptLanguage, "Accept-Language");
            this.append(vary, vAcceptEncoding, "Accept-Encoding");
            if (vary.length() > 0) {
                this.header("Vary", vary.toString());
            }
            return this;
        }

        private boolean vary(MediaType v, MediaType vary) {
            return v != null && !v.equals((Object)vary);
        }

        private boolean vary(Locale v, Locale vary) {
            return v != null && !v.equals(vary);
        }

        private boolean vary(String v, String vary) {
            return v != null && !v.equalsIgnoreCase(vary);
        }

        private void append(StringBuilder sb, boolean v, String s) {
            if (v) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(s);
            }
        }

        public Response.ResponseBuilder language(String language) {
            this.headerSingle("Content-Language", language);
            return this;
        }

        public Response.ResponseBuilder language(Locale language) {
            this.headerSingle("Content-Language", language);
            return this;
        }

        public Response.ResponseBuilder location(URI location) {
            URI baseUri;
            URI locationUri = location;
            if (location != null && !location.isAbsolute() && (baseUri = Builder.getBaseUri()) != null) {
                locationUri = baseUri.resolve(location);
            }
            this.headerSingle("Location", locationUri);
            return this;
        }

        public Response.ResponseBuilder contentLocation(URI location) {
            this.headerSingle("Content-Location", location);
            return this;
        }

        public Response.ResponseBuilder encoding(String encoding) {
            this.headerSingle("Content-Encoding", encoding);
            return this;
        }

        public Response.ResponseBuilder tag(EntityTag tag) {
            this.headerSingle("ETag", tag);
            return this;
        }

        public Response.ResponseBuilder tag(String tag) {
            return this.tag(tag == null ? null : new EntityTag(tag));
        }

        public Response.ResponseBuilder lastModified(Date lastModified) {
            this.headerSingle("Last-Modified", lastModified);
            return this;
        }

        public Response.ResponseBuilder cacheControl(CacheControl cacheControl) {
            this.headerSingle("Cache-Control", cacheControl);
            return this;
        }

        public Response.ResponseBuilder expires(Date expires) {
            this.headerSingle("Expires", expires);
            return this;
        }

        public Response.ResponseBuilder cookie(NewCookie ... cookies) {
            if (cookies != null) {
                for (NewCookie cookie : cookies) {
                    this.header("Set-Cookie", cookie);
                }
            } else {
                this.header("Set-Cookie", null);
            }
            return this;
        }

        public Response.ResponseBuilder header(String name, Object value) {
            return this.header(name, value, false);
        }

        private Response.ResponseBuilder headerSingle(String name, Object value) {
            return this.header(name, value, true);
        }

        private Response.ResponseBuilder header(String name, Object value, boolean single) {
            if (value != null) {
                if (single) {
                    this.context.getHeaders().putSingle((Object)name, value);
                } else {
                    this.context.getHeaders().add((Object)name, value);
                }
            } else {
                this.context.getHeaders().remove((Object)name);
            }
            return this;
        }

        public Response.ResponseBuilder variants(Variant ... variants) {
            return this.variants(Arrays.asList(variants));
        }

        public Response.ResponseBuilder links(Link ... links) {
            if (links != null) {
                for (Link link : links) {
                    this.header("Link", link);
                }
            } else {
                this.header("Link", null);
            }
            return this;
        }

        public Response.ResponseBuilder link(URI uri, String rel) {
            this.header("Link", Link.fromUri((URI)uri).rel(rel).build(new Object[0]));
            return this;
        }

        public Response.ResponseBuilder link(String uri, String rel) {
            this.header("Link", Link.fromUri((String)uri).rel(rel).build(new Object[0]));
            return this;
        }

        public Response.ResponseBuilder allow(String ... methods) {
            if (methods == null || methods.length == 1 && methods[0] == null) {
                return this.allow((Set<String>)null);
            }
            return this.allow(new HashSet<String>(Arrays.asList(methods)));
        }

        public Response.ResponseBuilder allow(Set<String> methods) {
            if (methods == null) {
                return this.header("Allow", null, true);
            }
            StringBuilder allow = new StringBuilder();
            for (String m : methods) {
                this.append(allow, true, m);
            }
            return this.header("Allow", allow, true);
        }

        public Response.ResponseBuilder replaceAll(MultivaluedMap<String, Object> headers) {
            this.context.replaceHeaders(headers);
            return this;
        }
    }
}

