/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.table;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import org.apache.knox.gateway.shell.table.KnoxShellTable;
import org.apache.knox.gateway.shell.table.KnoxShellTableBuilder;

public class CSVKnoxShellTableBuilder
extends KnoxShellTableBuilder {
    private boolean withHeaders;

    CSVKnoxShellTableBuilder(KnoxShellTable table) {
        super(table);
    }

    public CSVKnoxShellTableBuilder withHeaders() {
        this.withHeaders = true;
        return this;
    }

    public KnoxShellTable url(String url) throws IOException {
        URL urlToCsv = new URL(url);
        URLConnection connection = urlToCsv.openConnection();
        try (InputStreamReader urlConnectionStreamReader = new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8);
             BufferedReader csvReader = new BufferedReader(urlConnectionStreamReader);){
            this.buildTableFromCSVReader(csvReader);
        }
        return this.table;
    }

    public KnoxShellTable string(String csvString) throws IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(csvString.getBytes(StandardCharsets.UTF_8));
             InputStreamReader stringStreamReader = new InputStreamReader((InputStream)is, StandardCharsets.UTF_8);
             BufferedReader csvReader = new BufferedReader(stringStreamReader);){
            this.buildTableFromCSVReader(csvReader);
        }
        return this.table;
    }

    private void buildTableFromCSVReader(BufferedReader csvReader) throws IOException {
        int rowIndex = 0;
        if (this.title != null) {
            this.table.title(this.title);
        }
        String row = null;
        while ((row = csvReader.readLine()) != null) {
            String[] data;
            boolean addingHeaders;
            boolean bl = addingHeaders = this.withHeaders && rowIndex == 0;
            if (!addingHeaders) {
                this.table.row();
            }
            for (String value : data = row.split(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)", -1)) {
                if (addingHeaders) {
                    this.table.header(value);
                    continue;
                }
                this.table.value((Comparable<? extends Object>)((Object)value));
            }
            ++rowIndex;
        }
    }
}

