/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.hive;

import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModelGeneratorHandleResponse;
import org.apache.knox.gateway.topology.discovery.cm.model.hive.HiveServiceModelGenerator;

public class HiveOnTezServiceModelGenerator
extends HiveServiceModelGenerator {
    public static final String SERVICE_TYPE = "HIVE_ON_TEZ";
    static final String HIVEONTEZ_TRANSPORT_MODE = "hive.server2.transport.mode".replaceAll("\\.", "_");
    static final String HIVEONTEZ_HTTP_PORT = "hive.server2.thrift.http.port".replaceAll("\\.", "_");

    @Override
    public String getServiceType() {
        return SERVICE_TYPE;
    }

    @Override
    protected void checkHiveServer2HTTPMode(ApiConfigList roleConfig, ServiceModelGeneratorHandleResponse response) {
        String hiveServer2TransportMode = this.getRoleConfigValue(roleConfig, HIVEONTEZ_TRANSPORT_MODE);
        this.validateTransportMode(HIVEONTEZ_TRANSPORT_MODE, hiveServer2TransportMode, response);
    }

    @Override
    protected String getHttpPort(ApiConfigList roleConfig) {
        return this.getRoleConfigValue(roleConfig, HIVEONTEZ_HTTP_PORT);
    }

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) throws ApiException {
        ServiceModel model = super.generateService(service, serviceConfig, role, roleConfig);
        model.addRoleProperty(this.getRoleType(), HIVEONTEZ_HTTP_PORT, this.getRoleConfigValue(roleConfig, HIVEONTEZ_HTTP_PORT));
        model.addRoleProperty(this.getRoleType(), HIVEONTEZ_TRANSPORT_MODE, this.getRoleConfigValue(roleConfig, HIVEONTEZ_TRANSPORT_MODE));
        return model;
    }
}

