/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger;

import com.cloudera.api.swagger.client.ApiCallback;
import com.cloudera.api.swagger.client.ApiClient;
import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.client.ApiResponse;
import com.cloudera.api.swagger.client.Configuration;
import com.cloudera.api.swagger.client.Pair;
import com.cloudera.api.swagger.client.ProgressRequestBody;
import com.cloudera.api.swagger.client.ProgressResponseBody;
import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRoleConfigGroup;
import com.cloudera.api.swagger.model.ApiRoleConfigGroupList;
import com.cloudera.api.swagger.model.ApiRoleList;
import com.cloudera.api.swagger.model.ApiRoleNameList;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class RoleConfigGroupsResourceApi {
    private ApiClient apiClient;

    public RoleConfigGroupsResourceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RoleConfigGroupsResourceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call createRoleConfigGroupsCall(String clusterName, String serviceName, ApiRoleConfigGroupList body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiRoleConfigGroupList localVarPostBody = body;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/roleConfigGroups".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createRoleConfigGroupsValidateBeforeCall(String clusterName, String serviceName, ApiRoleConfigGroupList body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling createRoleConfigGroups(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling createRoleConfigGroups(Async)");
        }
        Call call = this.createRoleConfigGroupsCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        return call;
    }

    public ApiRoleConfigGroupList createRoleConfigGroups(String clusterName, String serviceName, ApiRoleConfigGroupList body) throws ApiException {
        ApiResponse<ApiRoleConfigGroupList> resp = this.createRoleConfigGroupsWithHttpInfo(clusterName, serviceName, body);
        return resp.getData();
    }

    public ApiResponse<ApiRoleConfigGroupList> createRoleConfigGroupsWithHttpInfo(String clusterName, String serviceName, ApiRoleConfigGroupList body) throws ApiException {
        Call call = this.createRoleConfigGroupsValidateBeforeCall(clusterName, serviceName, body, null, null);
        Type localVarReturnType = new TypeToken<ApiRoleConfigGroupList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createRoleConfigGroupsAsync(String clusterName, String serviceName, ApiRoleConfigGroupList body, final ApiCallback<ApiRoleConfigGroupList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createRoleConfigGroupsValidateBeforeCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiRoleConfigGroupList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteRoleConfigGroupCall(String clusterName, String roleConfigGroupName, String serviceName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/roleConfigGroups/{roleConfigGroupName}".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{roleConfigGroupName\\}", this.apiClient.escapeString(roleConfigGroupName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteRoleConfigGroupValidateBeforeCall(String clusterName, String roleConfigGroupName, String serviceName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling deleteRoleConfigGroup(Async)");
        }
        if (roleConfigGroupName == null) {
            throw new ApiException("Missing the required parameter 'roleConfigGroupName' when calling deleteRoleConfigGroup(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling deleteRoleConfigGroup(Async)");
        }
        Call call = this.deleteRoleConfigGroupCall(clusterName, roleConfigGroupName, serviceName, progressListener, progressRequestListener);
        return call;
    }

    public ApiRoleConfigGroup deleteRoleConfigGroup(String clusterName, String roleConfigGroupName, String serviceName) throws ApiException {
        ApiResponse<ApiRoleConfigGroup> resp = this.deleteRoleConfigGroupWithHttpInfo(clusterName, roleConfigGroupName, serviceName);
        return resp.getData();
    }

    public ApiResponse<ApiRoleConfigGroup> deleteRoleConfigGroupWithHttpInfo(String clusterName, String roleConfigGroupName, String serviceName) throws ApiException {
        Call call = this.deleteRoleConfigGroupValidateBeforeCall(clusterName, roleConfigGroupName, serviceName, null, null);
        Type localVarReturnType = new TypeToken<ApiRoleConfigGroup>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteRoleConfigGroupAsync(String clusterName, String roleConfigGroupName, String serviceName, final ApiCallback<ApiRoleConfigGroup> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteRoleConfigGroupValidateBeforeCall(clusterName, roleConfigGroupName, serviceName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiRoleConfigGroup>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call moveRolesCall(String clusterName, String roleConfigGroupName, String serviceName, ApiRoleNameList body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiRoleNameList localVarPostBody = body;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/roleConfigGroups/{roleConfigGroupName}/roles".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{roleConfigGroupName\\}", this.apiClient.escapeString(roleConfigGroupName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call moveRolesValidateBeforeCall(String clusterName, String roleConfigGroupName, String serviceName, ApiRoleNameList body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling moveRoles(Async)");
        }
        if (roleConfigGroupName == null) {
            throw new ApiException("Missing the required parameter 'roleConfigGroupName' when calling moveRoles(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling moveRoles(Async)");
        }
        Call call = this.moveRolesCall(clusterName, roleConfigGroupName, serviceName, body, progressListener, progressRequestListener);
        return call;
    }

    public ApiRoleList moveRoles(String clusterName, String roleConfigGroupName, String serviceName, ApiRoleNameList body) throws ApiException {
        ApiResponse<ApiRoleList> resp = this.moveRolesWithHttpInfo(clusterName, roleConfigGroupName, serviceName, body);
        return resp.getData();
    }

    public ApiResponse<ApiRoleList> moveRolesWithHttpInfo(String clusterName, String roleConfigGroupName, String serviceName, ApiRoleNameList body) throws ApiException {
        Call call = this.moveRolesValidateBeforeCall(clusterName, roleConfigGroupName, serviceName, body, null, null);
        Type localVarReturnType = new TypeToken<ApiRoleList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call moveRolesAsync(String clusterName, String roleConfigGroupName, String serviceName, ApiRoleNameList body, final ApiCallback<ApiRoleList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.moveRolesValidateBeforeCall(clusterName, roleConfigGroupName, serviceName, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiRoleList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call moveRolesToBaseGroupCall(String clusterName, String serviceName, ApiRoleNameList body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiRoleNameList localVarPostBody = body;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/roleConfigGroups/roles".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call moveRolesToBaseGroupValidateBeforeCall(String clusterName, String serviceName, ApiRoleNameList body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling moveRolesToBaseGroup(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling moveRolesToBaseGroup(Async)");
        }
        Call call = this.moveRolesToBaseGroupCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        return call;
    }

    public ApiRoleList moveRolesToBaseGroup(String clusterName, String serviceName, ApiRoleNameList body) throws ApiException {
        ApiResponse<ApiRoleList> resp = this.moveRolesToBaseGroupWithHttpInfo(clusterName, serviceName, body);
        return resp.getData();
    }

    public ApiResponse<ApiRoleList> moveRolesToBaseGroupWithHttpInfo(String clusterName, String serviceName, ApiRoleNameList body) throws ApiException {
        Call call = this.moveRolesToBaseGroupValidateBeforeCall(clusterName, serviceName, body, null, null);
        Type localVarReturnType = new TypeToken<ApiRoleList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call moveRolesToBaseGroupAsync(String clusterName, String serviceName, ApiRoleNameList body, final ApiCallback<ApiRoleList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.moveRolesToBaseGroupValidateBeforeCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiRoleList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call readConfigCall(String clusterName, String roleConfigGroupName, String serviceName, String view, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/roleConfigGroups/{roleConfigGroupName}/config".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{roleConfigGroupName\\}", this.apiClient.escapeString(roleConfigGroupName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (view != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "view", view));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call readConfigValidateBeforeCall(String clusterName, String roleConfigGroupName, String serviceName, String view, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling readConfig(Async)");
        }
        if (roleConfigGroupName == null) {
            throw new ApiException("Missing the required parameter 'roleConfigGroupName' when calling readConfig(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling readConfig(Async)");
        }
        Call call = this.readConfigCall(clusterName, roleConfigGroupName, serviceName, view, progressListener, progressRequestListener);
        return call;
    }

    public ApiConfigList readConfig(String clusterName, String roleConfigGroupName, String serviceName, String view) throws ApiException {
        ApiResponse<ApiConfigList> resp = this.readConfigWithHttpInfo(clusterName, roleConfigGroupName, serviceName, view);
        return resp.getData();
    }

    public ApiResponse<ApiConfigList> readConfigWithHttpInfo(String clusterName, String roleConfigGroupName, String serviceName, String view) throws ApiException {
        Call call = this.readConfigValidateBeforeCall(clusterName, roleConfigGroupName, serviceName, view, null, null);
        Type localVarReturnType = new TypeToken<ApiConfigList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call readConfigAsync(String clusterName, String roleConfigGroupName, String serviceName, String view, final ApiCallback<ApiConfigList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.readConfigValidateBeforeCall(clusterName, roleConfigGroupName, serviceName, view, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiConfigList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call readRoleConfigGroupCall(String clusterName, String roleConfigGroupName, String serviceName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/roleConfigGroups/{roleConfigGroupName}".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{roleConfigGroupName\\}", this.apiClient.escapeString(roleConfigGroupName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call readRoleConfigGroupValidateBeforeCall(String clusterName, String roleConfigGroupName, String serviceName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling readRoleConfigGroup(Async)");
        }
        if (roleConfigGroupName == null) {
            throw new ApiException("Missing the required parameter 'roleConfigGroupName' when calling readRoleConfigGroup(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling readRoleConfigGroup(Async)");
        }
        Call call = this.readRoleConfigGroupCall(clusterName, roleConfigGroupName, serviceName, progressListener, progressRequestListener);
        return call;
    }

    public ApiRoleConfigGroup readRoleConfigGroup(String clusterName, String roleConfigGroupName, String serviceName) throws ApiException {
        ApiResponse<ApiRoleConfigGroup> resp = this.readRoleConfigGroupWithHttpInfo(clusterName, roleConfigGroupName, serviceName);
        return resp.getData();
    }

    public ApiResponse<ApiRoleConfigGroup> readRoleConfigGroupWithHttpInfo(String clusterName, String roleConfigGroupName, String serviceName) throws ApiException {
        Call call = this.readRoleConfigGroupValidateBeforeCall(clusterName, roleConfigGroupName, serviceName, null, null);
        Type localVarReturnType = new TypeToken<ApiRoleConfigGroup>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call readRoleConfigGroupAsync(String clusterName, String roleConfigGroupName, String serviceName, final ApiCallback<ApiRoleConfigGroup> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.readRoleConfigGroupValidateBeforeCall(clusterName, roleConfigGroupName, serviceName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiRoleConfigGroup>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call readRoleConfigGroupsCall(String clusterName, String serviceName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/roleConfigGroups".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call readRoleConfigGroupsValidateBeforeCall(String clusterName, String serviceName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling readRoleConfigGroups(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling readRoleConfigGroups(Async)");
        }
        Call call = this.readRoleConfigGroupsCall(clusterName, serviceName, progressListener, progressRequestListener);
        return call;
    }

    public ApiRoleConfigGroupList readRoleConfigGroups(String clusterName, String serviceName) throws ApiException {
        ApiResponse<ApiRoleConfigGroupList> resp = this.readRoleConfigGroupsWithHttpInfo(clusterName, serviceName);
        return resp.getData();
    }

    public ApiResponse<ApiRoleConfigGroupList> readRoleConfigGroupsWithHttpInfo(String clusterName, String serviceName) throws ApiException {
        Call call = this.readRoleConfigGroupsValidateBeforeCall(clusterName, serviceName, null, null);
        Type localVarReturnType = new TypeToken<ApiRoleConfigGroupList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call readRoleConfigGroupsAsync(String clusterName, String serviceName, final ApiCallback<ApiRoleConfigGroupList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.readRoleConfigGroupsValidateBeforeCall(clusterName, serviceName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiRoleConfigGroupList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call readRolesCall(String clusterName, String roleConfigGroupName, String serviceName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/roleConfigGroups/{roleConfigGroupName}/roles".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{roleConfigGroupName\\}", this.apiClient.escapeString(roleConfigGroupName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call readRolesValidateBeforeCall(String clusterName, String roleConfigGroupName, String serviceName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling readRoles(Async)");
        }
        if (roleConfigGroupName == null) {
            throw new ApiException("Missing the required parameter 'roleConfigGroupName' when calling readRoles(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling readRoles(Async)");
        }
        Call call = this.readRolesCall(clusterName, roleConfigGroupName, serviceName, progressListener, progressRequestListener);
        return call;
    }

    public ApiRoleList readRoles(String clusterName, String roleConfigGroupName, String serviceName) throws ApiException {
        ApiResponse<ApiRoleList> resp = this.readRolesWithHttpInfo(clusterName, roleConfigGroupName, serviceName);
        return resp.getData();
    }

    public ApiResponse<ApiRoleList> readRolesWithHttpInfo(String clusterName, String roleConfigGroupName, String serviceName) throws ApiException {
        Call call = this.readRolesValidateBeforeCall(clusterName, roleConfigGroupName, serviceName, null, null);
        Type localVarReturnType = new TypeToken<ApiRoleList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call readRolesAsync(String clusterName, String roleConfigGroupName, String serviceName, final ApiCallback<ApiRoleList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.readRolesValidateBeforeCall(clusterName, roleConfigGroupName, serviceName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiRoleList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateConfigCall(String clusterName, String roleConfigGroupName, String serviceName, String message, ApiConfigList body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiConfigList localVarPostBody = body;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/roleConfigGroups/{roleConfigGroupName}/config".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{roleConfigGroupName\\}", this.apiClient.escapeString(roleConfigGroupName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (message != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "message", message));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateConfigValidateBeforeCall(String clusterName, String roleConfigGroupName, String serviceName, String message, ApiConfigList body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling updateConfig(Async)");
        }
        if (roleConfigGroupName == null) {
            throw new ApiException("Missing the required parameter 'roleConfigGroupName' when calling updateConfig(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling updateConfig(Async)");
        }
        Call call = this.updateConfigCall(clusterName, roleConfigGroupName, serviceName, message, body, progressListener, progressRequestListener);
        return call;
    }

    public ApiConfigList updateConfig(String clusterName, String roleConfigGroupName, String serviceName, String message, ApiConfigList body) throws ApiException {
        ApiResponse<ApiConfigList> resp = this.updateConfigWithHttpInfo(clusterName, roleConfigGroupName, serviceName, message, body);
        return resp.getData();
    }

    public ApiResponse<ApiConfigList> updateConfigWithHttpInfo(String clusterName, String roleConfigGroupName, String serviceName, String message, ApiConfigList body) throws ApiException {
        Call call = this.updateConfigValidateBeforeCall(clusterName, roleConfigGroupName, serviceName, message, body, null, null);
        Type localVarReturnType = new TypeToken<ApiConfigList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateConfigAsync(String clusterName, String roleConfigGroupName, String serviceName, String message, ApiConfigList body, final ApiCallback<ApiConfigList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateConfigValidateBeforeCall(clusterName, roleConfigGroupName, serviceName, message, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiConfigList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateRoleConfigGroupCall(String clusterName, String roleConfigGroupName, String serviceName, String message, ApiRoleConfigGroup body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiRoleConfigGroup localVarPostBody = body;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/roleConfigGroups/{roleConfigGroupName}".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{roleConfigGroupName\\}", this.apiClient.escapeString(roleConfigGroupName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (message != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "message", message));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateRoleConfigGroupValidateBeforeCall(String clusterName, String roleConfigGroupName, String serviceName, String message, ApiRoleConfigGroup body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling updateRoleConfigGroup(Async)");
        }
        if (roleConfigGroupName == null) {
            throw new ApiException("Missing the required parameter 'roleConfigGroupName' when calling updateRoleConfigGroup(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling updateRoleConfigGroup(Async)");
        }
        Call call = this.updateRoleConfigGroupCall(clusterName, roleConfigGroupName, serviceName, message, body, progressListener, progressRequestListener);
        return call;
    }

    public ApiRoleConfigGroup updateRoleConfigGroup(String clusterName, String roleConfigGroupName, String serviceName, String message, ApiRoleConfigGroup body) throws ApiException {
        ApiResponse<ApiRoleConfigGroup> resp = this.updateRoleConfigGroupWithHttpInfo(clusterName, roleConfigGroupName, serviceName, message, body);
        return resp.getData();
    }

    public ApiResponse<ApiRoleConfigGroup> updateRoleConfigGroupWithHttpInfo(String clusterName, String roleConfigGroupName, String serviceName, String message, ApiRoleConfigGroup body) throws ApiException {
        Call call = this.updateRoleConfigGroupValidateBeforeCall(clusterName, roleConfigGroupName, serviceName, message, body, null, null);
        Type localVarReturnType = new TypeToken<ApiRoleConfigGroup>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateRoleConfigGroupAsync(String clusterName, String roleConfigGroupName, String serviceName, String message, ApiRoleConfigGroup body, final ApiCallback<ApiRoleConfigGroup> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateRoleConfigGroupValidateBeforeCall(clusterName, roleConfigGroupName, serviceName, message, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiRoleConfigGroup>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

