/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.IOException;
import jdbm.recman.BlockIo;
import jdbm.recman.FreePhysicalRowId;
import jdbm.recman.FreePhysicalRowIdPage;
import jdbm.recman.Location;
import jdbm.recman.PageCursor;
import jdbm.recman.PageManager;
import jdbm.recman.PhysicalRowId;
import jdbm.recman.RecordFile;

final class FreePhysicalRowIdPageManager {
    protected RecordFile recordFile;
    protected PageManager pageManager;

    FreePhysicalRowIdPageManager(PageManager pageManager) throws IOException {
        this.recordFile = pageManager.getRecordFile();
        this.pageManager = pageManager;
    }

    Location get(int size) throws IOException {
        Location retval = null;
        PageCursor curs = new PageCursor(this.pageManager, 4);
        while (curs.next() != 0L) {
            FreePhysicalRowIdPage fp = FreePhysicalRowIdPage.getFreePhysicalRowIdPageView(this.recordFile.get(curs.getBlockId()));
            int slot = fp.getFirstLargerThan(size);
            if (slot != -1) {
                retval = new Location(fp.get(slot));
                fp.free(slot);
                if (fp.getCount() == 0) {
                    this.recordFile.release(curs.getBlockId(), false);
                    this.pageManager.free((short)4, curs.getBlockId());
                } else {
                    this.recordFile.release(curs.getBlockId(), true);
                }
                return retval;
            }
            this.recordFile.release(curs.getBlockId(), false);
        }
        return null;
    }

    void put(Location rowid, int size) throws IOException {
        FreePhysicalRowIdPage fp;
        BlockIo curBlock;
        PhysicalRowId free = null;
        PageCursor curs = new PageCursor(this.pageManager, 4);
        long freePage = 0L;
        while (curs.next() != 0L) {
            freePage = curs.getBlockId();
            curBlock = this.recordFile.get(freePage);
            fp = FreePhysicalRowIdPage.getFreePhysicalRowIdPageView(curBlock);
            int slot = fp.getFirstFree();
            if (slot != -1) {
                free = fp.alloc(slot);
                break;
            }
            this.recordFile.release(curBlock);
        }
        if (free == null) {
            freePage = this.pageManager.allocate((short)4);
            curBlock = this.recordFile.get(freePage);
            fp = FreePhysicalRowIdPage.getFreePhysicalRowIdPageView(curBlock);
            free = fp.alloc(0);
        }
        free.setBlock(rowid.getBlock());
        free.setOffset(rowid.getOffset());
        ((FreePhysicalRowId)free).setSize(size);
        this.recordFile.release(freePage, true);
    }
}

