/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.oozie;

import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.util.Locale;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.model.AbstractServiceModelGenerator;

public class OozieServiceModelGenerator
extends AbstractServiceModelGenerator {
    public static final String SERVICE = "OOZIE";
    public static final String SERVICE_TYPE = "OOZIE";
    public static final String ROLE_TYPE = "OOZIE_SERVER";
    static final String USE_SSL = "oozie_use_ssl";
    static final String HTTP_PORT = "oozie_http_port";
    static final String HTTPS_PORT = "oozie_https_port";

    @Override
    public String getService() {
        return "OOZIE";
    }

    @Override
    public String getServiceType() {
        return "OOZIE";
    }

    @Override
    public String getRoleType() {
        return ROLE_TYPE;
    }

    @Override
    public ServiceModel.Type getModelType() {
        return ServiceModel.Type.API;
    }

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) {
        String port;
        String scheme;
        String hostname = role.getHostRef().getHostname();
        String sslEnabled = this.getServiceConfigValue(serviceConfig, USE_SSL);
        if (Boolean.parseBoolean(sslEnabled)) {
            scheme = "https";
            port = this.getRoleConfigValue(roleConfig, HTTPS_PORT);
        } else {
            scheme = "http";
            port = this.getRoleConfigValue(roleConfig, HTTP_PORT);
        }
        ServiceModel model = this.createServiceModel(String.format(Locale.getDefault(), "%s://%s:%s/oozie/", scheme, hostname, port));
        model.addServiceProperty(USE_SSL, sslEnabled);
        model.addRoleProperty(this.getRoleType(), HTTP_PORT, this.getRoleConfigValue(roleConfig, HTTP_PORT));
        model.addRoleProperty(this.getRoleType(), HTTPS_PORT, this.getRoleConfigValue(roleConfig, HTTPS_PORT));
        return model;
    }
}

