/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.auth;

import org.ldaptive.Connection;
import org.ldaptive.LdapException;
import org.ldaptive.Response;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.auth.AbstractSearchEntryResolver;
import org.ldaptive.auth.AuthenticationCriteria;
import org.ldaptive.extended.WhoAmIOperation;
import org.ldaptive.extended.WhoAmIRequest;

public class WhoAmIEntryResolver
extends AbstractSearchEntryResolver {
    @Override
    protected SearchResult performLdapSearch(Connection conn, AuthenticationCriteria ac) throws LdapException {
        WhoAmIOperation whoami = new WhoAmIOperation(conn);
        Response res = whoami.execute(new WhoAmIRequest());
        this.logger.debug("whoami operation returned {}", res);
        String authzId = (String)res.getResult();
        if (authzId == null) {
            throw new IllegalStateException("WhoAmI operation did not return an authorization ID");
        }
        String dn = authzId.split(":", 2)[1].trim();
        SearchOperation search = this.createSearchOperation(conn);
        return (SearchResult)search.execute(this.createSearchRequest(ac, dn)).getResult();
    }

    protected SearchRequest createSearchRequest(AuthenticationCriteria ac, String dn) {
        SearchRequest request = SearchRequest.newObjectScopeSearchRequest(dn, ac.getAuthenticationRequest().getReturnAttributes());
        request.setDerefAliases(this.getDerefAliases());
        request.setFollowReferrals(this.getFollowReferrals());
        request.setSearchEntryHandlers(this.getSearchEntryHandlers());
        return request;
    }
}

