/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.config;

import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface GatewayConfig {
    public static final String GATEWAY_HOME_VAR = "GATEWAY_HOME";
    @Deprecated
    public static final String GATEWAY_CONF_HOME_VAR = "GATEWAY_CONF_HOME";
    public static final String KNOX_GATEWAY_CONF_DIR_VAR = "KNOX_GATEWAY_CONF_DIR";
    @Deprecated
    public static final String GATEWAY_DATA_HOME_VAR = "GATEWAY_DATA_HOME";
    public static final String KNOX_GATEWAY_DATA_DIR = "KNOX_GATEWAY_DATA_DIR";
    public static final String GATEWAY_CONFIG_ATTRIBUTE = "org.apache.knox.gateway.config";
    public static final String HADOOP_KERBEROS_SECURED = "gateway.hadoop.kerberos.secured";
    public static final String KRB5_CONFIG = "java.security.krb5.conf";
    public static final String KRB5_DEBUG = "sun.security.krb5.debug";
    public static final String KRB5_LOGIN_CONFIG = "java.security.auth.login.config";
    public static final String KRB5_USE_SUBJECT_CREDS_ONLY = "javax.security.auth.useSubjectCredsOnly";
    public static final String IDENTITY_KEYSTORE_PASSWORD_ALIAS = "gateway.tls.keystore.password.alias";
    public static final String IDENTITY_KEYSTORE_PATH = "gateway.tls.keystore.path";
    public static final String IDENTITY_KEYSTORE_TYPE = "gateway.tls.keystore.type";
    public static final String IDENTITY_KEY_ALIAS = "gateway.tls.key.alias";
    public static final String IDENTITY_KEY_PASSPHRASE_ALIAS = "gateway.tls.key.passphrase.alias";
    public static final String DEFAULT_IDENTITY_KEYSTORE_TYPE = "JKS";
    public static final String DEFAULT_IDENTITY_KEYSTORE_PASSWORD_ALIAS = "gateway-identity-keystore-password";
    public static final String DEFAULT_IDENTITY_KEY_ALIAS = "gateway-identity";
    public static final String DEFAULT_IDENTITY_KEY_PASSPHRASE_ALIAS = "gateway-identity-passphrase";
    public static final String DEFAULT_GATEWAY_KEYSTORE_NAME = "gateway.jks";
    public static final String SIGNING_KEYSTORE_NAME = "gateway.signing.keystore.name";
    public static final String SIGNING_KEYSTORE_PASSWORD_ALIAS = "gateway.signing.keystore.password.alias";
    public static final String SIGNING_KEYSTORE_TYPE = "gateway.signing.keystore.type";
    public static final String SIGNING_KEY_ALIAS = "gateway.signing.key.alias";
    public static final String SIGNING_KEY_PASSPHRASE_ALIAS = "gateway.signing.key.passphrase.alias";
    public static final String DEFAULT_SIGNING_KEYSTORE_PASSWORD_ALIAS = "signing.keystore.password";
    public static final String DEFAULT_SIGNING_KEYSTORE_TYPE = "JKS";
    public static final String DEFAULT_SIGNING_KEY_ALIAS = "gateway-identity";
    public static final String DEFAULT_SIGNING_KEY_PASSPHRASE_ALIAS = "signing.key.passphrase";
    public static final String GATEWAY_TRUSTSTORE_PASSWORD_ALIAS = "gateway.truststore.password.alias";
    public static final String GATEWAY_TRUSTSTORE_PATH = "gateway.truststore.path";
    public static final String GATEWAY_TRUSTSTORE_TYPE = "gateway.truststore.type";
    public static final String DEFAULT_GATEWAY_TRUSTSTORE_TYPE = "JKS";
    public static final String DEFAULT_GATEWAY_TRUSTSTORE_PASSWORD_ALIAS = "gateway-truststore-password";
    public static final String HTTP_CLIENT_TRUSTSTORE_PASSWORD_ALIAS = "gateway.httpclient.truststore.password.alias";
    public static final String HTTP_CLIENT_TRUSTSTORE_PATH = "gateway.httpclient.truststore.path";
    public static final String HTTP_CLIENT_TRUSTSTORE_TYPE = "gateway.httpclient.truststore.type";
    public static final String DEFAULT_HTTP_CLIENT_TRUSTSTORE_TYPE = "JKS";
    public static final String DEFAULT_HTTP_CLIENT_TRUSTSTORE_PASSWORD_ALIAS = "gateway-httpclient-truststore-password";
    public static final String REMOTE_CONFIG_REGISTRY_TYPE = "type";
    public static final String REMOTE_CONFIG_REGISTRY_ADDRESS = "address";
    public static final String REMOTE_CONFIG_REGISTRY_NAMESPACE = "namespace";
    public static final String REMOTE_CONFIG_REGISTRY_AUTH_TYPE = "authType";
    public static final String REMOTE_CONFIG_REGISTRY_PRINCIPAL = "principal";
    public static final String REMOTE_CONFIG_REGISTRY_CREDENTIAL_ALIAS = "credentialAlias";
    public static final String REMOTE_CONFIG_REGISTRY_KEYTAB = "keytab";
    public static final String REMOTE_CONFIG_REGISTRY_USE_KEYTAB = "useKeyTab";
    public static final String REMOTE_CONFIG_REGISTRY_USE_TICKET_CACHE = "useTicketCache";
    public static final String ZOOKEEPER_REMOTE_CONFIG_REGISTRY_BACKWARDS_COMPATIBLE = "backwardsCompatible";
    public static final String PROXYUSER_SERVICES_IGNORE_DOAS = "gateway.proxyuser.services.ignore.doas";

    public String getGatewayConfDir();

    public String getGatewayDataDir();

    public String getGatewayServicesDir();

    public String getGatewayApplicationsDir();

    public String getHadoopConfDir();

    public String getGatewayHost();

    public int getGatewayPort();

    public String getGatewayPath();

    public String getGatewayProvidersConfigDir();

    public String getGatewayDescriptorsDir();

    public String getGatewayTopologyDir();

    public String getGatewaySecurityDir();

    public String getGatewayKeystoreDir();

    public String getGatewayDeploymentDir();

    public InetSocketAddress getGatewayAddress() throws UnknownHostException;

    public boolean isSSLEnabled();

    public List<String> getExcludedSSLProtocols();

    public List<String> getIncludedSSLCiphers();

    public List<String> getExcludedSSLCiphers();

    public boolean isHadoopKerberosSecured();

    public String getKerberosConfig();

    public boolean isKerberosDebugEnabled();

    public String getKerberosLoginConfig();

    public String getDefaultTopologyName();

    public String getDefaultAppRedirectPath();

    public String getFrontendUrl();

    public boolean isClientAuthNeeded();

    public boolean isClientAuthWanted();

    public String getTruststorePath();

    public boolean getTrustAllCerts();

    public String getKeystoreType();

    public String getTruststoreType();

    public String getTruststorePasswordAlias();

    public boolean isXForwardedEnabled();

    public String getEphemeralDHKeySize();

    public int getHttpClientMaxConnections();

    public int getHttpClientConnectionTimeout();

    public int getHttpClientSocketTimeout();

    public String getHttpClientTruststorePath();

    public String getHttpClientTruststoreType();

    public String getHttpClientTruststorePasswordAlias();

    public int getThreadPoolMax();

    public int getHttpServerRequestBuffer();

    public int getHttpServerRequestHeaderBuffer();

    public int getHttpServerResponseBuffer();

    public int getHttpServerResponseHeaderBuffer();

    public int getGatewayDeploymentsBackupVersionLimit();

    public long getGatewayDeploymentsBackupAgeLimit();

    public long getGatewayIdleTimeout();

    public String getIdentityKeystorePath();

    public String getIdentityKeystoreType();

    public String getIdentityKeystorePasswordAlias();

    public String getIdentityKeyAlias();

    public String getIdentityKeyPassphraseAlias();

    public String getSigningKeystoreName();

    public String getSigningKeystorePath();

    public String getSigningKeystoreType();

    public String getSigningKeyAlias();

    public String getSigningKeystorePasswordAlias();

    public String getSigningKeyPassphraseAlias();

    public List<String> getGlobalRulesServices();

    public boolean isWebsocketEnabled();

    public int getWebsocketMaxTextMessageSize();

    public int getWebsocketMaxBinaryMessageSize();

    public int getWebsocketMaxTextMessageBufferSize();

    public int getWebsocketMaxBinaryMessageBufferSize();

    public int getWebsocketInputBufferSize();

    public int getWebsocketAsyncWriteTimeout();

    public int getWebsocketIdleTimeout();

    public int getWebsocketMaxWaitBufferCount();

    public boolean isMetricsEnabled();

    public boolean isJmxMetricsReportingEnabled();

    public boolean isGraphiteMetricsReportingEnabled();

    public String getGraphiteHost();

    public int getGraphitePort();

    public int getGraphiteReportingFrequency();

    public boolean isCookieScopingToPathEnabled();

    public String getHeaderNameForRemoteAddress();

    public String getAlgorithm();

    public String getPBEAlgorithm();

    public String getTransformation();

    public String getSaltSize();

    public String getIterationCount();

    public String getKeyLength();

    public Map<String, Integer> getGatewayPortMappings();

    public boolean isGatewayPortMappingEnabled();

    public boolean isGatewayServerHeaderEnabled();

    public String getDefaultDiscoveryAddress();

    public String getDefaultDiscoveryCluster();

    public int getClusterMonitorPollingInterval(String var1);

    public boolean isClusterMonitorEnabled(String var1);

    public List<String> getRemoteRegistryConfigurationNames();

    public String getRemoteRegistryConfiguration(String var1);

    public String getRemoteConfigurationMonitorClientName();

    public boolean allowUnauthenticatedRemoteRegistryReadAccess();

    public boolean isRemoteAliasServiceEnabled();

    public String getRemoteAliasServiceConfigurationPrefix();

    public Map<String, String> getRemoteAliasServiceConfiguration();

    public List<String> getReadOnlyOverrideTopologyNames();

    public String getKnoxAdminGroups();

    public String getKnoxAdminUsers();

    public String getFederationHeaderName();

    public List<String> getAutoDeployTopologyNames();

    public String getDispatchWhitelist();

    public List<String> getDispatchWhitelistServices();

    public boolean isTopologyValidationEnabled();

    public List<String> getXForwardContextAppendServices();

    public Set<String> getServicesToIgnoreDoAs();

    public long getClouderaManagerDescriptorsMonitoringInterval();

    public long getClouderaManagerAdvancedServiceDiscoveryConfigurationMonitoringInterval();

    public boolean isServerManagedTokenStateEnabled();

    public long getKnoxTokenEvictionInterval();

    public long getKnoxTokenEvictionGracePeriod();

    public Set<String> getHiddenTopologiesOnHomepage();

    public boolean isKnoxTokenPermissiveValidationEnabled();
}

