/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.client.direct;

import org.pac4j.core.client.DirectClient;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.http.credentials.extractor.CookieExtractor;

public class CookieClient
extends DirectClient<TokenCredentials, CommonProfile> {
    private String cookieName;

    public CookieClient() {
    }

    public CookieClient(String cookieName, Authenticator cookieAuthenticator) {
        this.cookieName = cookieName;
        this.defaultAuthenticator(cookieAuthenticator);
    }

    protected void clientInit() {
        CommonHelper.assertNotBlank((String)"cookieName", (String)this.cookieName);
        this.defaultCredentialsExtractor(new CookieExtractor(this.cookieName));
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }
}

