/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.workflow;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.knox.gateway.shell.AbstractRequest;
import org.apache.knox.gateway.shell.BasicResponse;
import org.apache.knox.gateway.shell.KnoxSession;

class Submit {
    Submit() {
    }

    public static class Response
    extends BasicResponse {
        Response(HttpResponse response) {
            super(response);
        }

        public String getJobId() throws IOException {
            return (String)JsonPath.read((String)this.getString(), (String)"$.id", (Predicate[])new Predicate[0]);
        }
    }

    public static class Request
    extends AbstractRequest<Response> {
        private String text;
        private String file;
        private String action = "start";

        Request(KnoxSession session) {
            super(session);
        }

        public Request text(String text) {
            this.text = text;
            return this;
        }

        public Request file(String file) {
            this.file = file;
            return this;
        }

        public Request action(String action) {
            this.action = action;
            return this;
        }

        @Override
        protected Callable<Response> callable() {
            return new Callable<Response>(){

                @Override
                public Response call() throws Exception {
                    URIBuilder uri = this.uri(new String[]{"/oozie/v1", "/jobs"});
                    this.addQueryParam(uri, "action", action);
                    HttpPost request = new HttpPost(uri.build());
                    StringEntity entity = null;
                    if (text != null) {
                        entity = new StringEntity(text, ContentType.create((String)"application/xml", (Charset)StandardCharsets.UTF_8));
                    } else if (file != null) {
                        entity = new FileEntity(new File(file), ContentType.create((String)"application/xml"));
                    }
                    request.setEntity(entity);
                    return new Response((HttpResponse)this.execute((HttpRequest)request));
                }
            };
        }
    }
}

