/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.gracefulDisconnect;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.extras.extended.gracefulDisconnect.GracefulDisconnectResponse;
import org.apache.directory.api.ldap.model.message.ExtendedResponseImpl;
import org.apache.directory.api.ldap.model.message.Referral;
import org.apache.directory.api.ldap.model.message.ReferralImpl;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;

public class GracefulDisconnectResponseImpl
extends ExtendedResponseImpl
implements GracefulDisconnectResponse {
    private int timeOffline;
    private int delay;
    private Referral replicatedContexts = new ReferralImpl();

    public GracefulDisconnectResponseImpl() {
        super(0, "1.3.6.1.4.1.18060.0.1.5");
    }

    public GracefulDisconnectResponseImpl(int timeOffline, int delay) {
        super(0, "1.3.6.1.4.1.18060.0.1.5");
        this.responseName = "1.3.6.1.4.1.18060.0.1.5";
        this.timeOffline = timeOffline;
        this.delay = delay;
        StringBuilder buf = new StringBuilder();
        buf.append("The server will disconnect and will be unavailable for ").append(timeOffline);
        buf.append(" minutes in ").append(delay).append(" seconds.");
        this.ldapResult.setDiagnosticMessage(buf.toString());
        this.ldapResult.setMatchedDn(null);
        this.ldapResult.setResultCode(ResultCodeEnum.UNAVAILABLE);
    }

    public String getResponseName() {
        return "1.3.6.1.4.1.18060.0.1.5";
    }

    public void setResponseName(String oid) {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_13504_FIX_OID, (Object[])new Object[]{"1.3.6.1.4.1.18060.0.1.5"}));
    }

    @Override
    public int getDelay() {
        return this.delay;
    }

    @Override
    public void setDelay(int delay) {
        this.delay = delay;
    }

    @Override
    public int getTimeOffline() {
        return this.timeOffline;
    }

    @Override
    public void setTimeOffline(int timeOffline) {
        this.timeOffline = timeOffline;
    }

    @Override
    public Referral getReplicatedContexts() {
        return this.replicatedContexts;
    }

    @Override
    public void addReplicatedContexts(String replicatedContext) {
        this.replicatedContexts.addLdapUrl(replicatedContext);
    }
}

