/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.filter.RequestUpdateHandler;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;

public class PortMappingHelperHandler
extends HandlerWrapper {
    private static final GatewayMessages LOG = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    final GatewayConfig config;
    private String defaultTopologyRedirectContext;

    public PortMappingHelperHandler(GatewayConfig config) {
        this.config = config;
        String defaultTopologyName = config.getDefaultTopologyName();
        if (defaultTopologyName == null && config.getGatewayPortMappings().values().contains(config.getGatewayPort())) {
            for (Map.Entry entry : config.getGatewayPortMappings().entrySet()) {
                if (((Integer)entry.getValue()).intValue() != config.getGatewayPort()) continue;
                this.defaultTopologyRedirectContext = "/" + config.getGatewayPath() + "/" + (String)entry.getKey();
                break;
            }
        }
        if (defaultTopologyName != null) {
            this.defaultTopologyRedirectContext = config.getDefaultAppRedirectPath();
            if (this.defaultTopologyRedirectContext != null && this.defaultTopologyRedirectContext.trim().isEmpty()) {
                this.defaultTopologyRedirectContext = null;
            }
        }
        if (this.defaultTopologyRedirectContext != null) {
            LOG.defaultTopologySetup(defaultTopologyName, this.defaultTopologyRedirectContext);
        }
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String newTarget = target;
        String baseURI = baseRequest.getRequestURI();
        if (this.config.isGatewayPortMappingEnabled()) {
            int index;
            String context = "";
            String originalContextPath = "";
            int targetIndex = StringUtils.ordinalIndexOf((CharSequence)target, (CharSequence)"/", (int)2);
            if (targetIndex > 0) {
                originalContextPath = target.substring(0, targetIndex + 1);
            } else if (targetIndex == -1 && (targetIndex = StringUtils.ordinalIndexOf((CharSequence)target, (CharSequence)"/", (int)1)) == 0) {
                originalContextPath = target;
            }
            if (!baseURI.startsWith(originalContextPath) && (index = StringUtils.ordinalIndexOf((CharSequence)baseURI, (CharSequence)"/", (int)3)) > 0) {
                context = baseURI.substring(0, index);
            }
            if (!StringUtils.isBlank((CharSequence)context)) {
                LOG.topologyPortMappingAddContext(target, context + target);
            }
            newTarget = context + target;
        }
        if (this.defaultTopologyRedirectContext != null && !baseURI.startsWith("/" + this.config.getGatewayPath())) {
            newTarget = this.defaultTopologyRedirectContext + target;
            RequestUpdateHandler.ForwardedRequest newRequest = new RequestUpdateHandler.ForwardedRequest(request, this.defaultTopologyRedirectContext, newTarget);
            LOG.defaultTopologyForward(target, newTarget);
            super.handle(newTarget, baseRequest, (HttpServletRequest)newRequest, response);
        } else {
            super.handle(newTarget, baseRequest, request, response);
        }
    }
}

