/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.impl.validationMapping10;

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.validationMapping10.AnnotationType;
import org.jboss.shrinkwrap.descriptor.api.validationMapping10.ElementType;
import org.jboss.shrinkwrap.descriptor.impl.validationMapping10.AnnotationTypeImpl;
import org.jboss.shrinkwrap.descriptor.spi.node.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementTypeImpl<T>
implements Child<T>,
ElementType<T> {
    private T t;
    private Node childNode;

    public ElementTypeImpl(T t, String nodeName, Node node) {
        this.t = t;
        this.childNode = node.createChild(nodeName);
    }

    public ElementTypeImpl(T t, String nodeName, Node node, Node childNode) {
        this.t = t;
        this.childNode = childNode;
    }

    public T up() {
        return this.t;
    }

    public ElementType<T> text(String value) {
        this.childNode.text(value);
        return this;
    }

    public String getText() {
        return this.childNode.getText();
    }

    public ElementType<T> value(String ... values) {
        if (values != null) {
            for (String name : values) {
                this.childNode.createChild("value").text(name);
            }
        }
        return this;
    }

    public List<String> getAllValue() {
        ArrayList<String> result = new ArrayList<String>();
        List nodes = this.childNode.get("value");
        for (Node node : nodes) {
            result.add(node.getText());
        }
        return result;
    }

    public ElementType<T> removeAllValue() {
        this.childNode.removeChildren("value");
        return this;
    }

    public AnnotationType<ElementType<T>> getOrCreateAnnotation() {
        List nodeList = this.childNode.get("annotation");
        if (nodeList != null && nodeList.size() > 0) {
            return new AnnotationTypeImpl<ElementType<T>>(this, "annotation", this.childNode, (Node)nodeList.get(0));
        }
        return this.createAnnotation();
    }

    public AnnotationType<ElementType<T>> createAnnotation() {
        return new AnnotationTypeImpl<ElementType<T>>(this, "annotation", this.childNode);
    }

    public List<AnnotationType<ElementType<T>>> getAllAnnotation() {
        ArrayList<AnnotationType<ElementType<T>>> list = new ArrayList<AnnotationType<ElementType<T>>>();
        List nodeList = this.childNode.get("annotation");
        for (Node node : nodeList) {
            AnnotationTypeImpl<ElementTypeImpl> type = new AnnotationTypeImpl<ElementTypeImpl>(this, "annotation", this.childNode, node);
            list.add(type);
        }
        return list;
    }

    public ElementType<T> removeAllAnnotation() {
        this.childNode.removeChildren("annotation");
        return this;
    }

    public ElementType<T> name(String name) {
        this.childNode.attribute("name", name);
        return this;
    }

    public String getName() {
        return this.childNode.getAttribute("name");
    }

    public ElementType<T> removeName() {
        this.childNode.removeAttribute("name");
        return this;
    }
}

