/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiTimeSeriesAggregateStatistics;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;

@ApiModel(description="A single data point of time series data.")
public class ApiTimeSeriesData {
    @SerializedName(value="timestamp")
    private String timestamp = null;
    @SerializedName(value="value")
    private BigDecimal value = null;
    @SerializedName(value="type")
    private String type = null;
    @SerializedName(value="aggregateStatistics")
    private ApiTimeSeriesAggregateStatistics aggregateStatistics = null;

    public ApiTimeSeriesData timestamp(String timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @ApiModelProperty(value="The timestamp for this time series data point. Note that the timestamp reflects coordinated universal time (UTC) and not necessarily the server's time zone. The rest API formats the UTC timestamp as an ISO-8061 string.")
    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public ApiTimeSeriesData value(BigDecimal value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(value="The value of the time series data.")
    public BigDecimal getValue() {
        return this.value;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    public ApiTimeSeriesData type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of the time series data.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ApiTimeSeriesData aggregateStatistics(ApiTimeSeriesAggregateStatistics aggregateStatistics) {
        this.aggregateStatistics = aggregateStatistics;
        return this;
    }

    @ApiModelProperty(value="Available from v6 for data points containing aggregate data. It includes further statistics about the data point. An aggregate can be across entities (e.g., fd_open_across_datanodes), over time (e.g., a daily point for the fd_open metric for a specific DataNode), or both (e.g., a daily point for the fd_open_across_datanodes metric). If the data point is for non-aggregate date this will return null.")
    public ApiTimeSeriesAggregateStatistics getAggregateStatistics() {
        return this.aggregateStatistics;
    }

    public void setAggregateStatistics(ApiTimeSeriesAggregateStatistics aggregateStatistics) {
        this.aggregateStatistics = aggregateStatistics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiTimeSeriesData apiTimeSeriesData = (ApiTimeSeriesData)o;
        return Objects.equals(this.timestamp, apiTimeSeriesData.timestamp) && Objects.equals(this.value, apiTimeSeriesData.value) && Objects.equals(this.type, apiTimeSeriesData.type) && Objects.equals(this.aggregateStatistics, apiTimeSeriesData.aggregateStatistics);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.value, this.type, this.aggregateStatistics);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiTimeSeriesData {\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    aggregateStatistics: ").append(this.toIndentedString(this.aggregateStatistics)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

