/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiHealthSummary;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents a result from a health test performed by Cloudera Manager for an entity.")
public class ApiHealthCheck {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="summary")
    private ApiHealthSummary summary = null;
    @SerializedName(value="explanation")
    private String explanation = null;
    @SerializedName(value="suppressed")
    private Boolean suppressed = null;

    public ApiHealthCheck name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Unique name of this health check.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApiHealthCheck summary(ApiHealthSummary summary) {
        this.summary = summary;
        return this;
    }

    @ApiModelProperty(value="The summary status of this check.")
    public ApiHealthSummary getSummary() {
        return this.summary;
    }

    public void setSummary(ApiHealthSummary summary) {
        this.summary = summary;
    }

    public ApiHealthCheck explanation(String explanation) {
        this.explanation = explanation;
        return this;
    }

    @ApiModelProperty(value="The explanation of this health check. Available since v11.")
    public String getExplanation() {
        return this.explanation;
    }

    public void setExplanation(String explanation) {
        this.explanation = explanation;
    }

    public ApiHealthCheck suppressed(Boolean suppressed) {
        this.suppressed = suppressed;
        return this;
    }

    @ApiModelProperty(value="Whether this health test is suppressed. A suppressed health test is not considered when computing an entity's overall health. Available since v11.")
    public Boolean getSuppressed() {
        return this.suppressed;
    }

    public void setSuppressed(Boolean suppressed) {
        this.suppressed = suppressed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiHealthCheck apiHealthCheck = (ApiHealthCheck)o;
        return Objects.equals(this.name, apiHealthCheck.name) && Objects.equals((Object)this.summary, (Object)apiHealthCheck.summary) && Objects.equals(this.explanation, apiHealthCheck.explanation) && Objects.equals(this.suppressed, apiHealthCheck.suppressed);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.summary, this.explanation, this.suppressed});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiHealthCheck {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    summary: ").append(this.toIndentedString((Object)this.summary)).append("\n");
        sb.append("    explanation: ").append(this.toIndentedString(this.explanation)).append("\n");
        sb.append("    suppressed: ").append(this.toIndentedString(this.suppressed)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

