/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.mvn.internal;

import java.io.File;
import shaded.org.eclipse.aether.RepositorySystemSession;
import shaded.org.eclipse.aether.artifact.Artifact;
import shaded.org.eclipse.aether.internal.impl.SimpleLocalRepositoryManagerFactory;
import shaded.org.eclipse.aether.metadata.Metadata;
import shaded.org.eclipse.aether.repository.LocalArtifactRegistration;
import shaded.org.eclipse.aether.repository.LocalArtifactRequest;
import shaded.org.eclipse.aether.repository.LocalArtifactResult;
import shaded.org.eclipse.aether.repository.LocalMetadataRegistration;
import shaded.org.eclipse.aether.repository.LocalMetadataRequest;
import shaded.org.eclipse.aether.repository.LocalMetadataResult;
import shaded.org.eclipse.aether.repository.LocalRepository;
import shaded.org.eclipse.aether.repository.LocalRepositoryManager;
import shaded.org.eclipse.aether.repository.NoLocalRepositoryManagerException;
import shaded.org.eclipse.aether.repository.RemoteRepository;

public class QosAwareSimpleLocalRepositoryManager
implements LocalRepositoryManager {
    LocalRepositoryManager delegate;

    public QosAwareSimpleLocalRepositoryManager(RepositorySystemSession session, LocalRepository repository) {
        SimpleLocalRepositoryManagerFactory factory = new SimpleLocalRepositoryManagerFactory();
        try {
            this.delegate = factory.newInstance(session, repository);
        }
        catch (NoLocalRepositoryManagerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public LocalArtifactResult find(RepositorySystemSession session, LocalArtifactRequest request) {
        String path = this.getPathForArtifact(request.getArtifact(), false);
        File file = new File(this.getRepository().getBasedir(), path);
        LocalArtifactResult result = new LocalArtifactResult(request);
        if (file.isFile()) {
            result.setFile(file);
            result.setAvailable(true);
        }
        if (request.getRepositories().size() != 0) {
            for (RemoteRepository repo : request.getRepositories()) {
                if (!"always".equals(session.getUpdatePolicy()) && !"always".equals(repo.getPolicy(false).getUpdatePolicy())) continue;
                result.setAvailable(false);
                result.setFile(null);
                break;
            }
        }
        return result;
    }

    String getPathForArtifact(Artifact artifact, boolean local) {
        StringBuilder path = new StringBuilder(128);
        path.append(artifact.getGroupId().replace('.', '/')).append('/');
        path.append(artifact.getArtifactId()).append('/');
        path.append(artifact.getBaseVersion()).append('/');
        path.append(artifact.getArtifactId()).append('-');
        if (local) {
            path.append(artifact.getBaseVersion());
        } else {
            path.append(artifact.getVersion());
        }
        if (artifact.getClassifier().length() > 0) {
            path.append('-').append(artifact.getClassifier());
        }
        if (artifact.getExtension().length() > 0) {
            path.append('.').append(artifact.getExtension());
        }
        return path.toString();
    }

    @Override
    public LocalRepository getRepository() {
        return this.delegate.getRepository();
    }

    @Override
    public String getPathForLocalArtifact(Artifact artifact) {
        return this.delegate.getPathForLocalArtifact(artifact);
    }

    @Override
    public String getPathForRemoteArtifact(Artifact artifact, RemoteRepository repository, String context) {
        return this.delegate.getPathForRemoteArtifact(artifact, repository, context);
    }

    @Override
    public String getPathForLocalMetadata(Metadata metadata) {
        return this.delegate.getPathForLocalMetadata(metadata);
    }

    @Override
    public String getPathForRemoteMetadata(Metadata metadata, RemoteRepository repository, String context) {
        return this.delegate.getPathForRemoteMetadata(metadata, repository, context);
    }

    @Override
    public void add(RepositorySystemSession session, LocalArtifactRegistration request) {
        this.delegate.add(session, request);
    }

    @Override
    public LocalMetadataResult find(RepositorySystemSession session, LocalMetadataRequest request) {
        return this.delegate.find(session, request);
    }

    @Override
    public void add(RepositorySystemSession session, LocalMetadataRegistration request) {
        this.delegate.add(session, request);
    }
}

