/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.publickey;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.utils.properties.Properties;
import org.apache.karaf.jaas.boot.principal.GroupPrincipal;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.jaas.modules.BackingEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublickeyBackingEngine
implements BackingEngine {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(PublickeyBackingEngine.class);
    private Properties users;

    public PublickeyBackingEngine(Properties users) {
        this.users = users;
    }

    @Override
    public void addUser(String username, String publickey) {
        if (username.startsWith("_g_:")) {
            throw new IllegalArgumentException("Prefix not permitted: _g_:");
        }
        this.addUserInternal(username, publickey);
    }

    private void addUserInternal(String username, String publickey) {
        String[] infos = null;
        StringBuffer userInfoBuffer = new StringBuffer();
        String newPublickey = publickey;
        String userInfos = (String)this.users.get(username);
        if (userInfos != null && userInfos.length() > 0) {
            infos = userInfos.split(",");
            userInfoBuffer.append(newPublickey);
            for (int i = 1; i < infos.length; ++i) {
                userInfoBuffer.append(",");
                userInfoBuffer.append(infos[i]);
            }
            String newUserInfo = userInfoBuffer.toString();
            this.users.put(username, newUserInfo);
        } else {
            this.users.put(username, newPublickey);
        }
        try {
            this.users.save();
        }
        catch (Exception ex) {
            LOGGER.error("Cannot update users file,", (Throwable)ex);
        }
    }

    @Override
    public void deleteUser(String username) {
        for (GroupPrincipal gp : this.listGroups(username)) {
            this.deleteGroup(username, gp.getName());
        }
        this.users.remove(username);
        try {
            this.users.save();
        }
        catch (Exception ex) {
            LOGGER.error("Cannot remove users file,", (Throwable)ex);
        }
    }

    @Override
    public List<UserPrincipal> listUsers() {
        ArrayList<UserPrincipal> result = new ArrayList<UserPrincipal>();
        for (Object user : this.users.keySet()) {
            String userName = (String)user;
            if (userName.startsWith("_g_:")) continue;
            UserPrincipal userPrincipal = new UserPrincipal(userName);
            result.add(userPrincipal);
        }
        return result;
    }

    @Override
    public List<RolePrincipal> listRoles(Principal principal) {
        String userName = principal.getName();
        if (principal instanceof GroupPrincipal) {
            userName = "_g_:" + userName;
        }
        return this.listRoles(userName);
    }

    private List<RolePrincipal> listRoles(String name) {
        ArrayList<RolePrincipal> result = new ArrayList<RolePrincipal>();
        String userInfo = (String)this.users.get(name);
        String[] infos = userInfo.split(",");
        for (int i = 1; i < infos.length; ++i) {
            String roleName = infos[i];
            if (roleName.startsWith("_g_:")) {
                for (RolePrincipal rp : this.listRoles(roleName)) {
                    if (result.contains(rp)) continue;
                    result.add(rp);
                }
                continue;
            }
            RolePrincipal rp = new RolePrincipal(roleName);
            if (result.contains(rp)) continue;
            result.add(rp);
        }
        return result;
    }

    @Override
    public void addRole(String username, String role) {
        String userInfos = (String)this.users.get(username);
        if (userInfos != null) {
            for (RolePrincipal rp : this.listRoles(username)) {
                if (!role.equals(rp.getName())) continue;
                return;
            }
            String newUserInfos = userInfos + "," + role;
            this.users.put(username, newUserInfos);
        }
        try {
            this.users.save();
        }
        catch (Exception ex) {
            LOGGER.error("Cannot update users file,", (Throwable)ex);
        }
    }

    @Override
    public void deleteRole(String username, String role) {
        String[] infos = null;
        StringBuffer userInfoBuffer = new StringBuffer();
        String userInfos = (String)this.users.get(username);
        if (userInfos != null && userInfos.length() > 0) {
            infos = userInfos.split(",");
            String password = infos[0];
            userInfoBuffer.append(password);
            for (int i = 1; i < infos.length; ++i) {
                if (infos[i] == null || infos[i].equals(role)) continue;
                userInfoBuffer.append(",");
                userInfoBuffer.append(infos[i]);
            }
            String newUserInfo = userInfoBuffer.toString();
            this.users.put(username, newUserInfo);
        }
        try {
            this.users.save();
        }
        catch (Exception ex) {
            LOGGER.error("Cannot update users file,", (Throwable)ex);
        }
    }

    @Override
    public List<GroupPrincipal> listGroups(UserPrincipal user) {
        String userName = user.getName();
        return this.listGroups(userName);
    }

    private List<GroupPrincipal> listGroups(String userName) {
        ArrayList<GroupPrincipal> result = new ArrayList<GroupPrincipal>();
        String userInfo = (String)this.users.get(userName);
        if (userInfo != null) {
            String[] infos = userInfo.split(",");
            for (int i = 1; i < infos.length; ++i) {
                String name = infos[i];
                if (!name.startsWith("_g_:")) continue;
                result.add(new GroupPrincipal(name.substring("_g_:".length())));
            }
        }
        return result;
    }

    @Override
    public void addGroup(String username, String group) {
        String groupName = "_g_:" + group;
        if (this.users.get(groupName) == null) {
            this.addUserInternal(groupName, "group");
        }
        this.addRole(username, groupName);
    }

    @Override
    public void deleteGroup(String username, String group) {
        this.deleteRole(username, "_g_:" + group);
        for (UserPrincipal user : this.listUsers()) {
            for (GroupPrincipal g : this.listGroups(user)) {
                if (!group.equals(g.getName())) continue;
                return;
            }
        }
        this.deleteUser("_g_:" + group);
    }

    @Override
    public void addGroupRole(String group, String role) {
        this.addRole("_g_:" + group, role);
    }

    @Override
    public void deleteGroupRole(String group, String role) {
        this.deleteRole("_g_:" + group, role);
    }

    @Override
    public Map<GroupPrincipal, String> listGroups() {
        HashMap<GroupPrincipal, String> result = new HashMap<GroupPrincipal, String>();
        for (String name : this.users.keySet()) {
            if (!name.startsWith("_g_:")) continue;
            result.put(new GroupPrincipal(name.substring("_g_:".length())), (String)this.users.get(name));
        }
        return result;
    }

    @Override
    public void createGroup(String group) {
        String groupName = "_g_:" + group;
        if (this.users.get(groupName) != null) {
            throw new IllegalArgumentException("Group: " + group + " already exist");
        }
        this.addUserInternal(groupName, "group");
    }
}

