/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jsonschema;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.juneau.collections.JsonList;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.parser.ParseException;

public class SchemaUtils {
    public static String joinnl(String[] ... s) {
        for (Object[] objectArray : s) {
            if (objectArray.length == 0) continue;
            return StringUtils.joinnl((Object[])objectArray).trim();
        }
        return "";
    }

    public static JsonMap parseMap(Object o) throws ParseException {
        if (o == null) {
            return null;
        }
        if (o instanceof String[]) {
            o = SchemaUtils.joinnl(new String[][]{(String[])o});
        }
        if (o instanceof String) {
            String o2 = (String)o;
            Object s = o2.toString();
            if (((String)s).isEmpty()) {
                return null;
            }
            if ("IGNORE".equalsIgnoreCase((String)s)) {
                return JsonMap.of(new Object[]{"ignore", true});
            }
            if (!StringUtils.isProbablyJsonObject((Object)s, (boolean)true)) {
                s = "{" + (String)s + "}";
            }
            return JsonMap.ofJson((CharSequence)s);
        }
        if (o instanceof JsonMap) {
            JsonMap o2 = (JsonMap)o;
            return o2;
        }
        throw new ParseException("Unexpected data type ''{0}''.  Expected JsonMap or String.", Utils.cn((Object)o));
    }

    public static JsonMap parseMap(String[] ss) throws ParseException {
        if (ss.length == 0) {
            return null;
        }
        Object s = SchemaUtils.joinnl(new String[][]{ss});
        if (((String)s).isEmpty()) {
            return null;
        }
        if (!StringUtils.isProbablyJsonObject((Object)s, (boolean)true)) {
            s = "{" + (String)s + "}";
        }
        return JsonMap.ofJson((CharSequence)s);
    }

    public static Set<String> parseSet(String[] ss) throws ParseException {
        if (ss.length == 0) {
            return null;
        }
        String s = SchemaUtils.joinnl(new String[][]{ss});
        if (s.isEmpty()) {
            return null;
        }
        LinkedHashSet set = CollectionUtils.set((Object[])new String[0]);
        JsonList.ofJsonOrCdl(s).forEach(x -> set.add(x.toString()));
        return set;
    }
}

