/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.part;

import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.assertions.FluentIntegerAssertion;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.part.BasicPart;

public class BasicIntegerPart
extends BasicPart {
    private final Integer value;
    private final Supplier<Integer> supplier;

    public static BasicIntegerPart of(String name, Integer value) {
        if (Utils.e((CharSequence)name) || value == null) {
            return null;
        }
        return new BasicIntegerPart(name, value);
    }

    public static BasicIntegerPart of(String name, Supplier<Integer> value) {
        if (Utils.e((CharSequence)name) || value == null) {
            return null;
        }
        return new BasicIntegerPart(name, value);
    }

    public BasicIntegerPart(String name, Integer value) {
        super(name, value);
        this.value = value;
        this.supplier = null;
    }

    public BasicIntegerPart(String name, String value) {
        super(name, value);
        this.value = Utils.e((CharSequence)value) ? null : Integer.valueOf(value);
        this.supplier = null;
    }

    public BasicIntegerPart(String name, Supplier<Integer> value) {
        super(name, value);
        this.value = null;
        this.supplier = value;
    }

    public Optional<Integer> asInteger() {
        return Utils.opt((Object)this.toInteger());
    }

    public FluentIntegerAssertion<BasicIntegerPart> assertInteger() {
        return new FluentIntegerAssertion(this.value(), (Object)this);
    }

    @Override
    public String getValue() {
        return Utils.s((Object)this.value());
    }

    public Integer orElse(Integer other) {
        Integer x = this.value();
        return Utils.nn((Object)x) ? x : other;
    }

    public Integer toInteger() {
        return this.value();
    }

    private Integer value() {
        if (Utils.nn(this.supplier)) {
            return this.supplier.get();
        }
        return this.value;
    }
}

