/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.config.store;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.Context;
import org.apache.juneau.commons.collections.Cache;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.collections.HashKey;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.FileUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.config.store.ConfigStore;
import org.apache.juneau.config.store.WatcherSensitivity;

public class FileStore
extends ConfigStore {
    public static final FileStore DEFAULT = FileStore.create().build();
    protected final boolean enableWatcher;
    protected final boolean updateOnWrite;
    protected final Charset charset;
    protected final String directory;
    protected final String extensions;
    protected final WatcherSensitivity watcherSensitivity;
    private final ConcurrentHashMap<String, String> cache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> nameCache = new ConcurrentHashMap();
    private final File dir;
    private final String[] exts;
    private final WatcherThread watcher;

    public static Builder create() {
        return new Builder();
    }

    public FileStore(Builder builder) {
        super(builder);
        this.directory = builder.directory;
        this.extensions = builder.extensions;
        this.charset = builder.charset;
        this.enableWatcher = builder.enableWatcher;
        this.updateOnWrite = builder.updateOnWrite;
        this.watcherSensitivity = builder.watcherSensitivity;
        try {
            this.dir = new File(this.directory).getCanonicalFile();
            this.dir.mkdirs();
            this.exts = (String[])StringUtils.split((String)this.extensions).toArray(String[]::new);
            WatcherThread watcherThread = this.watcher = this.enableWatcher ? new WatcherThread(this.dir, this.watcherSensitivity) : null;
            if (Utils.nn((Object)this.watcher)) {
                this.watcher.start();
            }
        }
        catch (Exception e) {
            throw ThrowableUtils.toRex((Throwable)e);
        }
    }

    @Override
    public synchronized void close() {
        if (Utils.nn((Object)this.watcher)) {
            this.watcher.interrupt();
        }
    }

    public Builder copy() {
        return new Builder(this);
    }

    @Override
    public synchronized boolean exists(String name) {
        return Files.exists(this.resolveFile(name), new LinkOption[0]);
    }

    @Override
    public synchronized String read(String name) throws IOException {
        name = this.resolveName(name);
        Path p = this.resolveFile(name);
        String s = this.cache.get(name = p.getFileName().toString());
        if (Utils.nn((Object)s)) {
            return s;
        }
        this.dir.mkdirs();
        if (!Files.exists(p, new LinkOption[0])) {
            return "";
        }
        boolean isWritable = this.isWritable(p);
        OpenOption[] oo = isWritable ? (StandardOpenOption[])CollectionUtils.a((Object[])new StandardOpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE}) : (StandardOpenOption[])CollectionUtils.a((Object[])new StandardOpenOption[]{StandardOpenOption.READ});
        try (FileChannel fc = FileChannel.open(p, oo);
             FileLock lock = isWritable ? fc.lock() : null;){
            ByteBuffer buf = ByteBuffer.allocate(1024);
            StringBuilder sb = new StringBuilder();
            while (fc.read(buf) != -1) {
                sb.append(this.charset.decode(buf.flip()));
                buf.clear();
            }
            s = sb.toString();
            this.cache.put(name, s);
        }
        return this.cache.get(name);
    }

    @Override
    public synchronized FileStore update(String name, String newContents) {
        this.cache.put(name, newContents);
        super.update(name, newContents);
        return this;
    }

    @Override
    public synchronized String write(String name, String expectedContents, String newContents) throws IOException {
        name = this.resolveName(name);
        if (Utils.eq((Object)expectedContents, (Object)newContents)) {
            return null;
        }
        this.dir.mkdirs();
        Path p = this.resolveFile(name);
        name = p.getFileName().toString();
        boolean exists = Files.exists(p, new LinkOption[0]);
        if (!exists && Utils.ne((CharSequence)expectedContents)) {
            return "";
        }
        if (this.isWritable(p)) {
            if (newContents == null) {
                Files.delete(p);
            } else {
                try (FileChannel fc = FileChannel.open(p, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
                     FileLock lock = fc.lock();){
                    String currentContents = "";
                    if (exists) {
                        ByteBuffer buf = ByteBuffer.allocate(1024);
                        StringBuilder sb = new StringBuilder();
                        while (fc.read(buf) != -1) {
                            sb.append(this.charset.decode(buf.flip()));
                            buf.clear();
                        }
                        currentContents = sb.toString();
                    }
                    if (Utils.nn((Object)expectedContents) && Utils.neq((Object)currentContents, (Object)expectedContents)) {
                        if (currentContents == null) {
                            this.cache.remove(name);
                        } else {
                            this.cache.put(name, currentContents);
                        }
                        String string = currentContents;
                        return string;
                    }
                    fc.position(0L);
                    fc.write(this.charset.encode(newContents));
                }
            }
        }
        if (this.updateOnWrite) {
            this.update(name, newContents);
        } else {
            this.cache.remove(name);
        }
        return null;
    }

    private synchronized boolean isWritable(Path p) {
        try {
            if (!Files.exists(p, new LinkOption[0])) {
                Files.createDirectories(p.getParent(), new FileAttribute[0]);
                if (!Files.exists(p, new LinkOption[0]) && !p.toFile().createNewFile()) {
                    throw ThrowableUtils.ioex((String)"Could not create file: {0}", (Object[])new Object[]{p});
                }
            }
        }
        catch (IOException e) {
            return false;
        }
        return Files.isWritable(p);
    }

    private Path resolveFile(String name) {
        return this.dir.toPath().resolve(this.resolveName(name));
    }

    protected synchronized void onFileEvent(WatchEvent<Path> e) throws IOException {
        String fn = e.context().getFileName().toString();
        String oldContents = this.cache.get(fn);
        this.cache.remove(fn);
        String newContents = this.read(fn);
        if (Utils.neq((Object)oldContents, (Object)newContents)) {
            this.update(fn, newContents);
        }
    }

    @Override
    protected FluentMap<String, Object> properties() {
        return super.properties().a((Object)"charset", (Object)this.charset).a((Object)"extensions", (Object)this.extensions).a((Object)"updateOnWrite", (Object)this.updateOnWrite);
    }

    @Override
    protected String resolveName(String name) {
        if (!this.nameCache.containsKey(name)) {
            Object n = null;
            if (FileUtils.fileExists((File)this.dir, (String)name)) {
                n = name;
            }
            if (n == null) {
                for (String ext : this.exts) {
                    if (!FileUtils.hasExtension((String)name, (String)ext)) continue;
                    n = name;
                    break;
                }
            }
            if (n == null) {
                for (String ext : this.exts) {
                    if (!FileUtils.fileExists((File)this.dir, (String)(name + "." + ext))) continue;
                    n = name + "." + ext;
                    break;
                }
            }
            if (n == null) {
                n = this.exts.length == 0 ? name : name + "." + this.exts[0];
            }
            this.nameCache.put(name, (String)n);
        }
        return this.nameCache.get(name);
    }

    public static class Builder
    extends ConfigStore.Builder {
        private Charset charset;
        private boolean enableWatcher;
        private boolean updateOnWrite;
        private String directory;
        private String extensions;
        private WatcherSensitivity watcherSensitivity;

        protected Builder() {
            this.charset = (Charset)Utils.env((String)"ConfigFileStore.charset").map(x -> Charset.forName(x)).orElse((Object)Charset.defaultCharset());
            this.directory = (String)Utils.env((String)"ConfigFileStore.directory", (Object)".");
            this.enableWatcher = (Boolean)Utils.env((String)"ConfigFileStore.enableWatcher", (Object)false);
            this.extensions = (String)Utils.env((String)"ConfigFileStore.extensions", (Object)"cfg");
            this.updateOnWrite = (Boolean)Utils.env((String)"ConfigFileStore.updateOnWrite", (Object)false);
            this.watcherSensitivity = (WatcherSensitivity)((Object)Utils.env((String)"ConfigFileStore.watcherSensitivity", (Object)((Object)WatcherSensitivity.MEDIUM)));
        }

        protected Builder(Builder copyFrom) {
            super((ConfigStore.Builder)((Object)AssertionUtils.assertArgNotNull((String)"copyFrom", (Object)((Object)copyFrom))));
            this.charset = copyFrom.charset;
            this.directory = copyFrom.directory;
            this.enableWatcher = copyFrom.enableWatcher;
            this.extensions = copyFrom.extensions;
            this.updateOnWrite = copyFrom.updateOnWrite;
            this.watcherSensitivity = copyFrom.watcherSensitivity;
        }

        protected Builder(FileStore copyFrom) {
            super((ConfigStore)AssertionUtils.assertArgNotNull((String)"copyFrom", (Object)copyFrom));
            this.type(copyFrom.getClass());
            this.charset = copyFrom.charset;
            this.directory = copyFrom.directory;
            this.enableWatcher = copyFrom.enableWatcher;
            this.extensions = copyFrom.extensions;
            this.updateOnWrite = copyFrom.updateOnWrite;
            this.watcherSensitivity = copyFrom.watcherSensitivity;
        }

        @Override
        public Builder annotations(Annotation ... values) {
            super.annotations(values);
            return this;
        }

        @Override
        public Builder apply(AnnotationWorkList work) {
            super.apply(work);
            return this;
        }

        @Override
        public Builder applyAnnotations(Class<?> ... from) {
            super.applyAnnotations((Class[])from);
            return this;
        }

        @Override
        public Builder applyAnnotations(Object ... from) {
            super.applyAnnotations(from);
            return this;
        }

        public FileStore build() {
            return (FileStore)this.build(FileStore.class);
        }

        @Override
        public Builder cache(Cache<HashKey, ? extends Context> value) {
            super.cache((Cache)value);
            return this;
        }

        public Builder charset(Charset value) {
            this.charset = (Charset)AssertionUtils.assertArgNotNull((String)"value", (Object)value);
            return this;
        }

        @Override
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        public Builder debug() {
            super.debug();
            return this;
        }

        @Override
        public Builder debug(boolean value) {
            super.debug(value);
            return this;
        }

        public Builder directory(File value) {
            this.directory = ((File)AssertionUtils.assertArgNotNull((String)"value", (Object)value)).getAbsolutePath();
            return this;
        }

        public Builder directory(String value) {
            this.directory = (String)AssertionUtils.assertArgNotNull((String)"value", (Object)value);
            return this;
        }

        public Builder enableWatcher() {
            this.enableWatcher = true;
            return this;
        }

        public Builder extensions(String value) {
            this.extensions = (String)AssertionUtils.assertArgNotNull((String)"value", (Object)value);
            return this;
        }

        @Override
        public Builder impl(Context value) {
            super.impl(value);
            return this;
        }

        @Override
        public Builder type(Class<? extends Context> value) {
            super.type((Class)value);
            return this;
        }

        public Builder updateOnWrite() {
            this.updateOnWrite = true;
            return this;
        }

        public Builder watcherSensitivity(WatcherSensitivity value) {
            this.watcherSensitivity = (WatcherSensitivity)((Object)AssertionUtils.assertArgNotNull((String)"value", (Object)((Object)value)));
            return this;
        }
    }

    class WatcherThread
    extends Thread {
        private final WatchService watchService = FileSystems.getDefault().newWatchService();

        WatcherThread(File dir, WatcherSensitivity s) throws Exception {
            WatchEvent.Kind[] kinds = (WatchEvent.Kind[])CollectionUtils.a((Object[])new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY});
            WatchEvent.Modifier modifier = this.lookupModifier(s);
            dir.toPath().register(this.watchService, kinds, modifier);
        }

        @Override
        public void interrupt() {
            try {
                this.watchService.close();
            }
            catch (IOException e) {
                throw ThrowableUtils.toRex((Throwable)e);
            }
            finally {
                super.interrupt();
            }
        }

        @Override
        public void run() {
            try {
                WatchKey key;
                while (Utils.nn((Object)(key = this.watchService.take()))) {
                    for (WatchEvent<Path> watchEvent : key.pollEvents()) {
                        WatchEvent.Kind<?> kind = watchEvent.kind();
                        if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                        FileStore.this.onFileEvent(watchEvent);
                    }
                    if (key.reset()) continue;
                    break;
                }
            }
            catch (Exception e) {
                throw ThrowableUtils.toRex((Throwable)e);
            }
        }

        private WatchEvent.Modifier lookupModifier(WatcherSensitivity s) {
            try {
                return switch (s) {
                    default -> throw new IncompatibleClassChangeError();
                    case WatcherSensitivity.LOW -> SensitivityWatchEventModifier.LOW;
                    case WatcherSensitivity.MEDIUM -> SensitivityWatchEventModifier.MEDIUM;
                    case WatcherSensitivity.HIGH -> SensitivityWatchEventModifier.HIGH;
                };
            }
            catch (Exception exception) {
                return null;
            }
        }
    }
}

