/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Set;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.dto.swagger.Items;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.dto.swagger.SwaggerElement;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.MultiSet;
import org.apache.juneau.marshaller.Json5;

@Bean(properties="description,type,format,items,collectionFormat,default,maximum,exclusiveMaximum,minimum,exclusiveMinimum,maxLength,minLength,pattern,maxItems,minItems,uniqueItems,enum,multipleOf,$ref,example,*")
@FluentSetters
public class HeaderInfo
extends SwaggerElement {
    private static final String[] VALID_TYPES = new String[]{"string", "number", "integer", "boolean", "array"};
    private static final String[] VALID_COLLECTION_FORMATS = new String[]{"csv", "ssv", "tsv", "pipes", "multi"};
    private String description;
    private String type;
    private String format;
    private String collectionFormat;
    private String pattern;
    private String ref;
    private Number maximum;
    private Number minimum;
    private Number multipleOf;
    private Integer maxLength;
    private Integer minLength;
    private Integer maxItems;
    private Integer minItems;
    private Boolean exclusiveMaximum;
    private Boolean exclusiveMinimum;
    private Boolean uniqueItems;
    private Items items;
    private Object _default;
    private Set<Object> _enum;
    private Object example;

    public HeaderInfo() {
    }

    public HeaderInfo(HeaderInfo copyFrom) {
        super(copyFrom);
        this.collectionFormat = copyFrom.collectionFormat;
        this._default = copyFrom._default;
        this.description = copyFrom.description;
        this._enum = CollectionUtils.copyOf(copyFrom._enum);
        this.example = copyFrom.example;
        this.exclusiveMaximum = copyFrom.exclusiveMaximum;
        this.exclusiveMinimum = copyFrom.exclusiveMinimum;
        this.format = copyFrom.format;
        this.items = copyFrom.items == null ? null : copyFrom.items.copy();
        this.maximum = copyFrom.maximum;
        this.maxItems = copyFrom.maxItems;
        this.maxLength = copyFrom.maxLength;
        this.minimum = copyFrom.minimum;
        this.minItems = copyFrom.minItems;
        this.minLength = copyFrom.minLength;
        this.multipleOf = copyFrom.multipleOf;
        this.pattern = copyFrom.pattern;
        this.type = copyFrom.type;
        this.uniqueItems = copyFrom.uniqueItems;
    }

    public HeaderInfo copy() {
        return new HeaderInfo(this);
    }

    @Override
    protected HeaderInfo strict() {
        super.strict();
        return this;
    }

    public String getCollectionFormat() {
        return this.collectionFormat;
    }

    public HeaderInfo setCollectionFormat(String value) {
        if (this.isStrict() && !ArrayUtils.contains((String)value, (String[])VALID_COLLECTION_FORMATS)) {
            throw new BasicRuntimeException("Invalid value passed in to setCollectionFormat(String).  Value=''{0}'', valid values={1}", new Object[]{value, Json5.of((Object)VALID_COLLECTION_FORMATS)});
        }
        this.collectionFormat = value;
        return this;
    }

    public Object getDefault() {
        return this._default;
    }

    public HeaderInfo setDefault(Object value) {
        this._default = value;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public HeaderInfo setDescription(String value) {
        this.description = value;
        return this;
    }

    public Set<Object> getEnum() {
        return this._enum;
    }

    public HeaderInfo setEnum(Collection<Object> value) {
        this._enum = CollectionUtils.setFrom(value);
        return this;
    }

    public HeaderInfo setEnum(Object ... value) {
        return this.setEnum(Arrays.asList(value));
    }

    public HeaderInfo addEnum(Object ... value) {
        this.setEnum(CollectionUtils.setBuilder(this._enum).sparse().add(value).build());
        return this;
    }

    public Object getExample() {
        return this.example;
    }

    public HeaderInfo setExample(Object value) {
        this.example = value;
        return this;
    }

    public Boolean getExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public HeaderInfo setExclusiveMaximum(Boolean value) {
        this.exclusiveMaximum = value;
        return this;
    }

    public Boolean getExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public HeaderInfo setExclusiveMinimum(Boolean value) {
        this.exclusiveMinimum = value;
        return this;
    }

    public String getFormat() {
        return this.format;
    }

    public HeaderInfo setFormat(String value) {
        this.format = value;
        return this;
    }

    public Items getItems() {
        return this.items;
    }

    public HeaderInfo setItems(Items value) {
        this.items = value;
        return this;
    }

    public Number getMaximum() {
        return this.maximum;
    }

    public HeaderInfo setMaximum(Number value) {
        this.maximum = value;
        return this;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public HeaderInfo setMaxItems(Integer value) {
        this.maxItems = value;
        return this;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public HeaderInfo setMaxLength(Integer value) {
        this.maxLength = value;
        return this;
    }

    public Number getMinimum() {
        return this.minimum;
    }

    public HeaderInfo setMinimum(Number value) {
        this.minimum = value;
        return this;
    }

    public Integer getMinItems() {
        return this.minItems;
    }

    public HeaderInfo setMinItems(Integer value) {
        this.minItems = value;
        return this;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public HeaderInfo setMinLength(Integer value) {
        this.minLength = value;
        return this;
    }

    public Number getMultipleOf() {
        return this.multipleOf;
    }

    public HeaderInfo setMultipleOf(Number value) {
        this.multipleOf = value;
        return this;
    }

    public String getPattern() {
        return this.pattern;
    }

    public HeaderInfo setPattern(String value) {
        this.pattern = value;
        return this;
    }

    @Beanp(value="$ref")
    public String getRef() {
        return this.ref;
    }

    @Beanp(value="$ref")
    public HeaderInfo setRef(String value) {
        this.ref = value;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public HeaderInfo setType(String value) {
        if (this.isStrict() && !ArrayUtils.contains((String)value, (String[])VALID_TYPES)) {
            throw new BasicRuntimeException("Invalid value passed in to setType(String).  Value=''{0}'', valid values={1}", new Object[]{value, Json5.of((Object)VALID_TYPES)});
        }
        this.type = value;
        return this;
    }

    public Boolean getUniqueItems() {
        return this.uniqueItems;
    }

    public HeaderInfo setUniqueItems(Boolean value) {
        this.uniqueItems = value;
        return this;
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "collectionFormat": {
                return (T)ConverterUtils.toType((Object)this.getCollectionFormat(), type);
            }
            case "default": {
                return (T)ConverterUtils.toType((Object)this.getDefault(), type);
            }
            case "description": {
                return (T)this.getDescription();
            }
            case "enum": {
                return (T)ConverterUtils.toType(this.getEnum(), type);
            }
            case "example": {
                return (T)ConverterUtils.toType((Object)this.getExample(), type);
            }
            case "exclusiveMaximum": {
                return (T)ConverterUtils.toType((Object)this.getExclusiveMaximum(), type);
            }
            case "exclusiveMinimum": {
                return (T)ConverterUtils.toType((Object)this.getExclusiveMinimum(), type);
            }
            case "format": {
                return (T)ConverterUtils.toType((Object)this.getFormat(), type);
            }
            case "items": {
                return (T)ConverterUtils.toType((Object)this.getItems(), type);
            }
            case "maximum": {
                return (T)ConverterUtils.toType((Object)this.getMaximum(), type);
            }
            case "maxItems": {
                return (T)ConverterUtils.toType((Object)this.getMaxItems(), type);
            }
            case "maxLength": {
                return (T)ConverterUtils.toType((Object)this.getMaxLength(), type);
            }
            case "minimum": {
                return (T)ConverterUtils.toType((Object)this.getMinimum(), type);
            }
            case "minItems": {
                return (T)ConverterUtils.toType((Object)this.getMinItems(), type);
            }
            case "minLength": {
                return (T)ConverterUtils.toType((Object)this.getMinLength(), type);
            }
            case "multipleOf": {
                return (T)ConverterUtils.toType((Object)this.getMultipleOf(), type);
            }
            case "pattern": {
                return (T)ConverterUtils.toType((Object)this.getPattern(), type);
            }
            case "$ref": {
                return (T)ConverterUtils.toType((Object)this.getRef(), type);
            }
            case "type": {
                return (T)ConverterUtils.toType((Object)this.getType(), type);
            }
            case "uniqueItems": {
                return (T)ConverterUtils.toType((Object)this.getUniqueItems(), type);
            }
        }
        return super.get(property, type);
    }

    @Override
    public HeaderInfo set(String property, Object value) {
        if (property == null) {
            return this;
        }
        switch (property) {
            case "collectionFormat": {
                return this.setCollectionFormat(StringUtils.stringify((Object)value));
            }
            case "default": {
                return this.setDefault(value);
            }
            case "description": {
                return this.setDescription(StringUtils.stringify((Object)value));
            }
            case "enum": {
                return this.setEnum(CollectionUtils.setBuilder(Object.class, (Type[])new Type[0]).sparse().addAny(new Object[]{value}).build());
            }
            case "example": {
                return this.setExample(value);
            }
            case "exclusiveMaximum": {
                return this.setExclusiveMaximum(ConverterUtils.toBoolean((Object)value));
            }
            case "exclusiveMinimum": {
                return this.setExclusiveMinimum(ConverterUtils.toBoolean((Object)value));
            }
            case "format": {
                return this.setFormat(StringUtils.stringify((Object)value));
            }
            case "items": {
                return this.setItems((Items)ConverterUtils.toType((Object)value, Items.class));
            }
            case "maximum": {
                return this.setMaximum(ConverterUtils.toNumber((Object)value));
            }
            case "maxItems": {
                return this.setMaxItems(ConverterUtils.toInteger((Object)value));
            }
            case "maxLength": {
                return this.setMaxLength(ConverterUtils.toInteger((Object)value));
            }
            case "minimum": {
                return this.setMinimum(ConverterUtils.toNumber((Object)value));
            }
            case "minItems": {
                return this.setMinItems(ConverterUtils.toInteger((Object)value));
            }
            case "minLength": {
                return this.setMinLength(ConverterUtils.toInteger((Object)value));
            }
            case "multipleOf": {
                return this.setMultipleOf(ConverterUtils.toNumber((Object)value));
            }
            case "pattern": {
                return this.setPattern(StringUtils.stringify((Object)value));
            }
            case "$ref": {
                return this.setRef(StringUtils.stringify((Object)value));
            }
            case "type": {
                return this.setType(StringUtils.stringify((Object)value));
            }
            case "uniqueItems": {
                return this.setUniqueItems(ConverterUtils.toBoolean((Object)value));
            }
        }
        super.set(property, value);
        return this;
    }

    @Override
    public Set<String> keySet() {
        Set s = CollectionUtils.setBuilder(String.class, (Type[])new Type[0]).addIf(this.collectionFormat != null, (Object)"collectionFormat").addIf(this._default != null, (Object)"default").addIf(this.description != null, (Object)"description").addIf(this._enum != null, (Object)"enum").addIf(this.example != null, (Object)"example").addIf(this.exclusiveMaximum != null, (Object)"exclusiveMaximum").addIf(this.exclusiveMinimum != null, (Object)"exclusiveMinimum").addIf(this.format != null, (Object)"format").addIf(this.items != null, (Object)"items").addIf(this.maximum != null, (Object)"maximum").addIf(this.maxItems != null, (Object)"maxItems").addIf(this.maxLength != null, (Object)"maxLength").addIf(this.minimum != null, (Object)"minimum").addIf(this.minItems != null, (Object)"minItems").addIf(this.minLength != null, (Object)"minLength").addIf(this.multipleOf != null, (Object)"multipleOf").addIf(this.pattern != null, (Object)"pattern").addIf(this.ref != null, (Object)"$ref").addIf(this.type != null, (Object)"type").addIf(this.uniqueItems != null, (Object)"uniqueItems").build();
        return new MultiSet(new Collection[]{s, super.keySet()});
    }

    public HeaderInfo resolveRefs(Swagger swagger, Deque<String> refStack, int maxDepth) {
        if (this.ref != null) {
            if (refStack.contains(this.ref) || refStack.size() >= maxDepth) {
                return this;
            }
            refStack.addLast(this.ref);
            HeaderInfo r = swagger.findRef(this.ref, HeaderInfo.class).resolveRefs(swagger, refStack, maxDepth);
            refStack.removeLast();
            return r;
        }
        if (this.items != null) {
            this.items = this.items.resolveRefs(swagger, refStack, maxDepth);
        }
        return this;
    }
}

