/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.lang.reflect.Constructor;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ConstructorInfo;

public class HeaderBeanMeta<T> {
    private static final ConcurrentHashMap<Class<?>, HeaderBeanMeta<?>> CACHE = new ConcurrentHashMap();
    private final Class<T> type;
    private final Constructor<T> constructor;
    private final HttpPartSchema schema;

    public static <T> HeaderBeanMeta<T> of(Class<T> type) {
        HeaderBeanMeta<Object> m = CACHE.get(type);
        if (m == null) {
            m = new HeaderBeanMeta<T>(type);
            CACHE.put(type, m);
        }
        return m;
    }

    private HeaderBeanMeta(Class<T> type) {
        this.type = type;
        ClassInfo ci = ClassInfo.of(type);
        ConstructorInfo cci = ci.getPublicConstructor(x -> x.hasParamTypes(String.class));
        if (cci == null) {
            cci = ci.getPublicConstructor(x -> x.hasParamTypes(Object.class));
        }
        if (cci == null) {
            cci = ci.getPublicConstructor(x -> x.hasParamTypes(String.class, String.class));
        }
        if (cci == null) {
            cci = ci.getPublicConstructor(x -> x.hasParamTypes(String.class, Object.class));
        }
        this.constructor = cci == null ? null : cci.inner();
        this.schema = HttpPartSchema.create(Header.class, type);
    }

    public HttpPartSchema getSchema() {
        return this.schema;
    }

    public T construct(Object value) {
        return this.construct(null, value);
    }

    public T construct(String name, Object value) {
        if (this.constructor == null) {
            throw ThrowableUtils.unsupportedOperationException("Constructor for type {0} could not be found.", this.type.getName());
        }
        if (name == null) {
            name = this.schema.getName();
        }
        Class<?>[] pt = this.constructor.getParameterTypes();
        Object[] args = new Object[pt.length];
        if (pt.length == 1) {
            args[0] = pt[0] == String.class ? StringUtils.stringify(value) : value;
        } else {
            if (name == null) {
                throw ThrowableUtils.unsupportedOperationException("Constructor for type {0} requires a name as the first argument.", this.type.getName());
            }
            args[0] = name;
            args[1] = pt[1] == String.class ? StringUtils.stringify(value) : value;
        }
        try {
            return this.constructor.newInstance(args);
        }
        catch (Exception e) {
            throw ThrowableUtils.runtimeException(e);
        }
    }
}

