/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.BeanContext;
import org.apache.juneau.annotation.TargetedAnnotationTImpl;
import org.apache.juneau.annotation.TargetedAnnotationTMBuilder;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.annotation.Schema;
import org.apache.juneau.http.annotation.SchemaAnnotation;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.svl.VarResolverSession;

public class ResponseAnnotation {
    public static final Response DEFAULT = ResponseAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(Class<?> ... on) {
        return ResponseAnnotation.create().on((Class[])on);
    }

    public static Builder create(String ... on) {
        return ResponseAnnotation.create().on(on);
    }

    public static boolean empty(Response a) {
        return a == null || DEFAULT.equals(a);
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Array {
        public Response[] value();
    }

    public static class Applier
    extends AnnotationApplier<Response, BeanContext.Builder> {
        public Applier(VarResolverSession vr) {
            super(Response.class, BeanContext.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<Response> ai, BeanContext.Builder b) {
            Response a = ai.inner();
            if (ArrayUtils.isEmptyArray(a.on(), a.onClass())) {
                return;
            }
            b.annotations(a);
        }
    }

    private static class Impl
    extends TargetedAnnotationTImpl
    implements Response {
        private final Class<? extends HttpPartParser> parser;
        private final Class<? extends HttpPartSerializer> serializer;
        private final Header[] headers;
        private final Schema schema;
        private final String[] examples;

        Impl(Builder b) {
            super(b);
            this.examples = ArrayUtils.copyOf(b.examples);
            this.headers = ArrayUtils.copyOf(b.headers);
            this.parser = b.parser;
            this.schema = b.schema;
            this.serializer = b.serializer;
            this.postConstruct();
        }

        @Override
        public String[] examples() {
            return this.examples;
        }

        @Override
        public Header[] headers() {
            return this.headers;
        }

        @Override
        public Class<? extends HttpPartParser> parser() {
            return this.parser;
        }

        @Override
        public Schema schema() {
            return this.schema;
        }

        @Override
        public Class<? extends HttpPartSerializer> serializer() {
            return this.serializer;
        }
    }

    public static class Builder
    extends TargetedAnnotationTMBuilder {
        Class<? extends HttpPartParser> parser = HttpPartParser.Void.class;
        Class<? extends HttpPartSerializer> serializer = HttpPartSerializer.Void.class;
        Header[] headers = new Header[0];
        Schema schema = SchemaAnnotation.DEFAULT;
        String[] examples = new String[0];

        protected Builder() {
            super(Response.class);
        }

        public Response build() {
            return new Impl(this);
        }

        public Builder examples(String ... value) {
            this.examples = value;
            return this;
        }

        public Builder headers(Header ... value) {
            this.headers = value;
            return this;
        }

        public Builder parser(Class<? extends HttpPartParser> value) {
            this.parser = value;
            return this;
        }

        public Builder schema(Schema value) {
            this.schema = value;
            return this;
        }

        public Builder serializer(Class<? extends HttpPartSerializer> value) {
            this.serializer = value;
            return this;
        }

        @Override
        public Builder on(String ... values) {
            super.on(values);
            return this;
        }

        @Override
        public Builder on(Class<?> ... value) {
            super.on((Class[])value);
            return this;
        }

        @Override
        public Builder onClass(Class<?> ... value) {
            super.onClass((Class[])value);
            return this;
        }

        @Override
        public Builder on(Method ... value) {
            super.on(value);
            return this;
        }
    }
}

