/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.openapi3;

import java.lang.reflect.Type;
import java.util.Set;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.dto.openapi3.OpenApiElement;
import org.apache.juneau.dto.swagger.ExternalDocumentation;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.MultiSet;
import org.apache.juneau.internal.StringUtils;

@Bean(properties="name,description,externalDocs,*")
@FluentSetters
public class Tag
extends OpenApiElement {
    private String name;
    private String description;
    private ExternalDocumentation externalDocs;

    public Tag() {
    }

    public Tag(Tag copyFrom) {
        super(copyFrom);
        this.name = copyFrom.name;
        this.description = copyFrom.description;
        this.externalDocs = copyFrom.externalDocs == null ? null : copyFrom.externalDocs.copy();
    }

    public Tag copy() {
        return new Tag(this);
    }

    public String getName() {
        return this.name;
    }

    public Tag setName(String value) {
        this.name = value;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Tag setDescription(String value) {
        this.description = value;
        return this;
    }

    public ExternalDocumentation getExternalDocs() {
        return this.externalDocs;
    }

    public Tag setExternalDocs(ExternalDocumentation value) {
        this.externalDocs = value;
        return this;
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "name": {
                return ConverterUtils.toType(this.getName(), type);
            }
            case "description": {
                return ConverterUtils.toType(this.getDescription(), type);
            }
            case "externalDocs": {
                return ConverterUtils.toType(this.getExternalDocs(), type);
            }
        }
        return super.get(property, type);
    }

    @Override
    public Tag set(String property, Object value) {
        if (property == null) {
            return this;
        }
        switch (property) {
            case "name": {
                return this.setName(StringUtils.stringify(value));
            }
            case "description": {
                return this.setDescription(StringUtils.stringify(value));
            }
            case "externalDocs": {
                return this.setExternalDocs(ConverterUtils.toType(value, ExternalDocumentation.class));
            }
        }
        super.set(property, value);
        return this;
    }

    @Override
    public Set<String> keySet() {
        Set<String> s = CollectionUtils.setBuilder(String.class, new Type[0]).addIf(this.name != null, "name").addIf(this.description != null, "description").addIf(this.externalDocs != null, "externalDocs").build();
        return new MultiSet<String>(s, super.keySet());
    }
}

