/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.reflect;

import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ConstructorInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.reflect.Mutater;
import org.apache.juneau.reflect.ReflectFlags;

public class Mutaters {
    private static final ConcurrentHashMap<Class<?>, Map<Class<?>, Mutater<?, ?>>> CACHE = new ConcurrentHashMap();
    public static final Mutater<Object, Object> NULL = new Mutater<Object, Object>(){

        @Override
        public Object mutate(Object outer, Object in) {
            return null;
        }
    };

    public static synchronized void add(Class<?> ic, Class<?> oc, Mutater<?, ?> t) {
        Map<Class<?>, Mutater<?, ?>> m = CACHE.get(oc);
        if (m == null) {
            m = new ConcurrentHashMap();
            CACHE.put(oc, m);
        }
        m.put(ic, t);
    }

    public static <I, O> Mutater<I, O> get(Class<I> ic, Class<O> oc) {
        Mutater t;
        if (ic == null || oc == null) {
            return null;
        }
        Map<Class<?>, Mutater<?, ?>> m = CACHE.get(oc);
        if (m == null) {
            m = new ConcurrentHashMap();
            CACHE.putIfAbsent(oc, m);
            m = CACHE.get(oc);
        }
        if ((t = m.get(ic)) == null) {
            t = Mutaters.find(ic, oc, m);
            m.put(ic, t);
        }
        return t == NULL ? null : t;
    }

    public static <I, O> boolean hasMutate(Class<I> ic, Class<O> oc) {
        return Mutaters.get(ic, oc) != NULL;
    }

    private static Mutater find(Class<?> ic, Class<?> oc, Map<Class<?>, Mutater<?, ?>> m) {
        ConstructorInfo c;
        if (ic == oc) {
            return new Mutater(){

                public Object mutate(Object outer, Object in) {
                    return in;
                }
            };
        }
        ClassInfo ici = ClassInfo.of(ic);
        ClassInfo oci = ClassInfo.of(oc);
        for (ClassInfo pic : ici.getAllParents()) {
            Mutater<?, ?> t = m.get(pic.inner());
            if (t == null) continue;
            return t;
        }
        if (ic == String.class) {
            final Class<?> oc2 = oci.hasPrimitiveWrapper() ? oci.getPrimitiveWrapper() : oc;
            ClassInfo oc2i = ClassInfo.of(oc2);
            final MethodInfo createMethod = oc2i.getStaticCreateMethod(ic, "forName");
            if (oc2.isEnum() && createMethod == null) {
                return new Mutater<String, Object>(){

                    @Override
                    public Object mutate(Object outer, String in) {
                        return Enum.valueOf(oc2, in);
                    }
                };
            }
            if (createMethod != null) {
                return new Mutater<String, Object>(){

                    @Override
                    public Object mutate(Object outer, String in) {
                        try {
                            return createMethod.invoke(null, in);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
            }
        } else {
            MethodInfo createMethod = oci.getStaticCreateMethod(ic, new String[0]);
            if (createMethod != null) {
                final Method cm = createMethod.inner();
                return new Mutater(){

                    public Object mutate(Object context, Object in) {
                        try {
                            return cm.invoke(null, in);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
            }
        }
        if ((c = oci.getPublicConstructor(ic)) != null && c.isNotDeprecated()) {
            final boolean isMemberClass = oci.isNonStaticMemberClass();
            return new Mutater(){

                public Object mutate(Object outer, Object in) {
                    try {
                        if (isMemberClass) {
                            return c.invoke(outer, in);
                        }
                        return c.invoke(in);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
        final MethodInfo toXMethod = Mutaters.findToXMethod(ici, oci);
        if (toXMethod != null) {
            return new Mutater(){

                public Object mutate(Object outer, Object in) {
                    try {
                        return toXMethod.invoke(in, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
        return NULL;
    }

    private static MethodInfo findToXMethod(ClassInfo ic, ClassInfo oc) {
        String tn = oc.getReadableName();
        for (MethodInfo m : ic.getAllMethods()) {
            if (!m.isAll(ReflectFlags.PUBLIC, ReflectFlags.NOT_STATIC, ReflectFlags.HAS_NO_PARAMS, ReflectFlags.NOT_DEPRECATED) || !m.getSimpleName().startsWith("to") || !m.getSimpleName().substring(2).equalsIgnoreCase(tn)) continue;
            return m;
        }
        return null;
    }

    static {
        Mutaters.add(String.class, TimeZone.class, new Mutater<String, TimeZone>(){

            @Override
            public TimeZone mutate(Object outer, String in) {
                return TimeZone.getTimeZone(in);
            }
        });
        Mutaters.add(TimeZone.class, String.class, new Mutater<TimeZone, String>(){

            @Override
            public String mutate(Object outer, TimeZone in) {
                return in.getID();
            }
        });
        Mutaters.add(String.class, Locale.class, new Mutater<String, Locale>(){

            @Override
            public Locale mutate(Object outer, String in) {
                return Locale.forLanguageTag(in.replace('_', '-'));
            }
        });
        Mutaters.add(String.class, Boolean.class, new Mutater<String, Boolean>(){

            @Override
            public Boolean mutate(Object outer, String in) {
                if (in == null || "null".equals(in) || in.isEmpty()) {
                    return null;
                }
                return Boolean.valueOf(in);
            }
        });
    }
}

