/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.juneau.internal.StringUtils;

public enum ConfigMod {
    ENCODED("*");

    private final String c;

    private ConfigMod(String c) {
        this.c = c;
    }

    public static String asString(ConfigMod ... mods) {
        if (mods.length == 0) {
            return "";
        }
        if (mods.length == 1) {
            return mods[0].c;
        }
        StringBuilder sb = new StringBuilder(mods.length);
        for (ConfigMod m : mods) {
            sb.append(m.c);
        }
        return sb.toString();
    }

    private static ConfigMod fromChar(char c) {
        if (c == '*') {
            return ENCODED;
        }
        return null;
    }

    public static List<ConfigMod> asModifiersReverse(String s) {
        if (StringUtils.isEmpty(s)) {
            return Collections.emptyList();
        }
        if (s.length() == 1) {
            ConfigMod m = ConfigMod.fromChar(s.charAt(0));
            return m == null ? Collections.emptyList() : Collections.singletonList(m);
        }
        ArrayList<ConfigMod> l = new ArrayList<ConfigMod>(s.length());
        for (int i = s.length() - 1; i >= 0; --i) {
            ConfigMod m = ConfigMod.fromChar(s.charAt(i));
            if (m == null) continue;
            l.add(m);
        }
        return l;
    }

    public static List<ConfigMod> asModifiers(String s) {
        if (StringUtils.isEmpty(s)) {
            return Collections.emptyList();
        }
        if (s.length() == 1) {
            ConfigMod m = ConfigMod.fromChar(s.charAt(0));
            return m == null ? Collections.emptyList() : Collections.singletonList(m);
        }
        ArrayList<ConfigMod> l = new ArrayList<ConfigMod>(s.length());
        for (int i = 0; i < s.length(); ++i) {
            ConfigMod m = ConfigMod.fromChar(s.charAt(i));
            if (m == null) continue;
            l.add(m);
        }
        return l;
    }
}

