/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.httppart;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.juneau.ContextRuntimeException;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.Value;
import org.apache.juneau.http.annotation.AnnotationUtils;
import org.apache.juneau.http.annotation.Body;
import org.apache.juneau.http.annotation.FormData;
import org.apache.juneau.http.annotation.HasFormData;
import org.apache.juneau.http.annotation.HasQuery;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.Path;
import org.apache.juneau.http.annotation.Query;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.annotation.ResponseHeader;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.jsonschema.annotation.Items;
import org.apache.juneau.jsonschema.annotation.Schema;
import org.apache.juneau.jsonschema.annotation.SubItems;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ParamInfo;
import org.apache.juneau.utils.ASet;

public class HttpPartSchemaBuilder {
    String name;
    String _default;
    Set<Integer> codes;
    Set<String> _enum;
    Boolean allowEmptyValue;
    Boolean exclusiveMaximum;
    Boolean exclusiveMinimum;
    Boolean required;
    Boolean uniqueItems;
    Boolean skipIfEmpty;
    HttpPartSchema.CollectionFormat collectionFormat = HttpPartSchema.CollectionFormat.NO_COLLECTION_FORMAT;
    HttpPartSchema.Type type = HttpPartSchema.Type.NO_TYPE;
    HttpPartSchema.Format format = HttpPartSchema.Format.NO_FORMAT;
    Pattern pattern;
    Number maximum;
    Number minimum;
    Number multipleOf;
    Long maxLength;
    Long minLength;
    Long maxItems;
    Long minItems;
    Long maxProperties;
    Long minProperties;
    Map<String, HttpPartSchemaBuilder> properties;
    HttpPartSchemaBuilder items;
    HttpPartSchemaBuilder additionalProperties;
    boolean noValidate;
    Class<? extends HttpPartParser> parser;
    Class<? extends HttpPartSerializer> serializer;

    public HttpPartSchema build() {
        return new HttpPartSchema(this);
    }

    HttpPartSchemaBuilder apply(Class<? extends Annotation> c, ParamInfo mpi) {
        this.apply(c, mpi.getParameterType().innerType());
        for (Annotation a : mpi.getDeclaredAnnotations()) {
            if (!c.isInstance(a)) continue;
            this.apply(a);
        }
        return this;
    }

    HttpPartSchemaBuilder apply(Class<? extends Annotation> c, Method m) {
        this.apply(c, m.getGenericReturnType());
        Annotation a = m.getAnnotation(c);
        if (a != null) {
            return this.apply(a);
        }
        return this;
    }

    HttpPartSchemaBuilder apply(Class<? extends Annotation> c, Type t) {
        if (t instanceof Class) {
            ClassInfo ci = ClassInfo.of((Class)t);
            for (Annotation annotation : ci.getAnnotationsParentFirst(c)) {
                this.apply(annotation);
            }
        } else if (Value.isType(t)) {
            this.apply(c, Value.getParameterType(t));
        }
        return this;
    }

    public HttpPartSchemaBuilder apply(Annotation a) {
        if (a instanceof Body) {
            this.apply((Body)a);
        } else if (a instanceof Header) {
            this.apply((Header)a);
        } else if (a instanceof FormData) {
            this.apply((FormData)a);
        } else if (a instanceof Query) {
            this.apply((Query)a);
        } else if (a instanceof Path) {
            this.apply((Path)a);
        } else if (a instanceof Response) {
            this.apply((Response)a);
        } else if (a instanceof ResponseHeader) {
            this.apply((ResponseHeader)a);
        } else if (a instanceof HasQuery) {
            this.apply((HasQuery)a);
        } else if (a instanceof HasFormData) {
            this.apply((HasFormData)a);
        } else if (a instanceof Schema) {
            this.apply((Schema)a);
        } else {
            throw new RuntimeException("HttpPartSchemaBuilder.apply(@" + a.getClass().getSimpleName() + ") not defined");
        }
        return this;
    }

    HttpPartSchemaBuilder apply(Body a) {
        this.required(a.required());
        this.allowEmptyValue(!a.required());
        this.apply(a.schema());
        return this;
    }

    HttpPartSchemaBuilder apply(Header a) {
        this.name(a.value());
        this.name(a.name());
        this.required(a.required());
        this.type(a.type());
        this.format(a.format());
        this.allowEmptyValue(a.allowEmptyValue());
        this.items(a.items());
        this.collectionFormat(a.collectionFormat());
        this._default(a._default().length == 0 ? null : StringUtils.joinnl(a._default()));
        this.maximum(HttpPartSchema.toNumber(a.maximum()));
        this.exclusiveMaximum(a.exclusiveMaximum());
        this.minimum(HttpPartSchema.toNumber(a.minimum()));
        this.exclusiveMinimum(a.exclusiveMinimum());
        this.maxLength(a.maxLength());
        this.minLength(a.minLength());
        this.pattern(a.pattern());
        this.maxItems(a.maxItems());
        this.minItems(a.minItems());
        this.uniqueItems(a.uniqueItems());
        this._enum(HttpPartSchema.toSet(a._enum()));
        this.multipleOf(HttpPartSchema.toNumber(a.multipleOf()));
        this.skipIfEmpty(a.skipIfEmpty());
        this.parser(a.parser());
        this.serializer(a.serializer());
        return this;
    }

    HttpPartSchemaBuilder apply(ResponseHeader a) {
        this.name(a.value());
        this.name(a.name());
        this.codes(a.code());
        this.type(a.type());
        this.format(a.format());
        this.items(a.items());
        this.collectionFormat(a.collectionFormat());
        this._default(a._default().length == 0 ? null : StringUtils.joinnl(a._default()));
        this.maximum(HttpPartSchema.toNumber(a.maximum()));
        this.exclusiveMaximum(a.exclusiveMaximum());
        this.minimum(HttpPartSchema.toNumber(a.minimum()));
        this.exclusiveMinimum(a.exclusiveMinimum());
        this.maxLength(a.maxLength());
        this.minLength(a.minLength());
        this.pattern(a.pattern());
        this.maxItems(a.maxItems());
        this.minItems(a.minItems());
        this.uniqueItems(a.uniqueItems());
        this._enum(HttpPartSchema.toSet(a._enum()));
        this.multipleOf(HttpPartSchema.toNumber(a.multipleOf()));
        this.allowEmptyValue(false);
        this.serializer(a.serializer());
        return this;
    }

    HttpPartSchemaBuilder apply(FormData a) {
        this.name(a.value());
        this.name(a.name());
        this.required(a.required());
        this.type(a.type());
        this.format(a.format());
        this.allowEmptyValue(a.allowEmptyValue());
        this.items(a.items());
        this.collectionFormat(a.collectionFormat());
        this._default(a._default().length == 0 ? null : StringUtils.joinnl(a._default()));
        this.maximum(HttpPartSchema.toNumber(a.maximum()));
        this.exclusiveMaximum(a.exclusiveMaximum());
        this.minimum(HttpPartSchema.toNumber(a.minimum()));
        this.exclusiveMinimum(a.exclusiveMinimum());
        this.maxLength(a.maxLength());
        this.minLength(a.minLength());
        this.pattern(a.pattern());
        this.maxItems(a.maxItems());
        this.minItems(a.minItems());
        this.uniqueItems(a.uniqueItems());
        this._enum(HttpPartSchema.toSet(a._enum()));
        this.multipleOf(HttpPartSchema.toNumber(a.multipleOf()));
        this.skipIfEmpty(a.skipIfEmpty());
        this.parser(a.parser());
        this.serializer(a.serializer());
        return this;
    }

    HttpPartSchemaBuilder apply(Query a) {
        this.name(a.value());
        this.name(a.name());
        this.required(a.required());
        this.type(a.type());
        this.format(a.format());
        this.allowEmptyValue(a.allowEmptyValue());
        this.items(a.items());
        this.collectionFormat(a.collectionFormat());
        this._default(a._default().length == 0 ? null : StringUtils.joinnl(a._default()));
        this.maximum(HttpPartSchema.toNumber(a.maximum()));
        this.exclusiveMaximum(a.exclusiveMaximum());
        this.minimum(HttpPartSchema.toNumber(a.minimum()));
        this.exclusiveMinimum(a.exclusiveMinimum());
        this.maxLength(a.maxLength());
        this.minLength(a.minLength());
        this.pattern(a.pattern());
        this.maxItems(a.maxItems());
        this.minItems(a.minItems());
        this.uniqueItems(a.uniqueItems());
        this._enum(HttpPartSchema.toSet(a._enum()));
        this.multipleOf(HttpPartSchema.toNumber(a.multipleOf()));
        this.skipIfEmpty(a.skipIfEmpty());
        this.parser(a.parser());
        this.serializer(a.serializer());
        return this;
    }

    HttpPartSchemaBuilder apply(Path a) {
        this.name(a.value());
        this.name(a.name());
        this.type(a.type());
        this.format(a.format());
        this.items(a.items());
        this.allowEmptyValue(a.allowEmptyValue());
        this.collectionFormat(a.collectionFormat());
        this.maximum(HttpPartSchema.toNumber(a.maximum()));
        this.exclusiveMaximum(a.exclusiveMaximum());
        this.minimum(HttpPartSchema.toNumber(a.minimum()));
        this.exclusiveMinimum(a.exclusiveMinimum());
        this.maxLength(a.maxLength());
        this.minLength(a.minLength());
        this.pattern(a.pattern());
        this.maxItems(a.maxItems());
        this.minItems(a.minItems());
        this.uniqueItems(a.uniqueItems());
        this._enum(HttpPartSchema.toSet(a._enum()));
        this.multipleOf(HttpPartSchema.toNumber(a.multipleOf()));
        this.parser(a.parser());
        this.serializer(a.serializer());
        if (StringUtils.startsWith(this.name, '/')) {
            this.allowEmptyValue();
        } else {
            this.required(true);
        }
        return this;
    }

    HttpPartSchemaBuilder apply(Response a) {
        this.codes(a.value());
        this.codes(a.code());
        this.required(false);
        this.allowEmptyValue(true);
        this.serializer(a.partSerializer());
        this.parser(a.partParser());
        this.apply(a.schema());
        return this;
    }

    HttpPartSchemaBuilder apply(Items a) {
        this.type(a.type());
        this.format(a.format());
        this.items(a.items());
        this.collectionFormat(a.collectionFormat());
        this._default(a._default().length == 0 ? null : StringUtils.joinnl(a._default()));
        this.maximum(HttpPartSchema.toNumber(a.maximum()));
        this.exclusiveMaximum(a.exclusiveMaximum());
        this.minimum(HttpPartSchema.toNumber(a.minimum()));
        this.exclusiveMinimum(a.exclusiveMinimum());
        this.maxLength(a.maxLength());
        this.minLength(a.minLength());
        this.pattern(a.pattern());
        this.maxItems(a.maxItems());
        this.minItems(a.minItems());
        this.uniqueItems(a.uniqueItems());
        this._enum(HttpPartSchema.toSet(a._enum()));
        this.multipleOf(HttpPartSchema.toNumber(a.multipleOf()));
        return this;
    }

    HttpPartSchemaBuilder apply(SubItems a) {
        this.type(a.type());
        this.format(a.format());
        this.items(HttpPartSchema.toObjectMap(a.items()));
        this.collectionFormat(a.collectionFormat());
        this._default(a._default().length == 0 ? null : StringUtils.joinnl(a._default()));
        this.maximum(HttpPartSchema.toNumber(a.maximum()));
        this.exclusiveMaximum(a.exclusiveMaximum());
        this.minimum(HttpPartSchema.toNumber(a.minimum()));
        this.exclusiveMinimum(a.exclusiveMinimum());
        this.maxLength(a.maxLength());
        this.minLength(a.minLength());
        this.pattern(a.pattern());
        this.maxItems(a.maxItems());
        this.minItems(a.minItems());
        this.uniqueItems(a.uniqueItems());
        this._enum(HttpPartSchema.toSet(a._enum()));
        this.multipleOf(HttpPartSchema.toNumber(a.multipleOf()));
        return this;
    }

    HttpPartSchemaBuilder apply(Schema a) {
        this.type(a.type());
        this.format(a.format());
        this.items(a.items());
        this.collectionFormat(a.collectionFormat());
        this._default(a._default().length == 0 ? null : StringUtils.joinnl(a._default()));
        this.maximum(HttpPartSchema.toNumber(a.maximum()));
        this.exclusiveMaximum(a.exclusiveMaximum());
        this.minimum(HttpPartSchema.toNumber(a.minimum()));
        this.exclusiveMinimum(a.exclusiveMinimum());
        this.maxLength(a.maxLength());
        this.minLength(a.minLength());
        this.pattern(a.pattern());
        this.maxItems(a.maxItems());
        this.minItems(a.minItems());
        this.uniqueItems(a.uniqueItems());
        this._enum(HttpPartSchema.toSet(a._enum()));
        this.multipleOf(HttpPartSchema.toNumber(a.multipleOf()));
        this.maxProperties(a.maxProperties());
        this.minProperties(a.minProperties());
        this.properties(HttpPartSchema.toObjectMap(a.properties()));
        this.additionalProperties(HttpPartSchema.toObjectMap(a.additionalProperties()));
        return this;
    }

    HttpPartSchemaBuilder apply(HasQuery a) {
        this.name(a.value());
        this.name(a.name());
        return this;
    }

    HttpPartSchemaBuilder apply(HasFormData a) {
        this.name(a.value());
        this.name(a.name());
        return this;
    }

    HttpPartSchemaBuilder apply(ObjectMap m) {
        if (m != null && !m.isEmpty()) {
            this._default(m.getString("default"));
            this._enum(HttpPartSchema.toSet(m.getString("enum")));
            this.allowEmptyValue(m.getBoolean("allowEmptyValue"));
            this.exclusiveMaximum(m.getBoolean("exclusiveMaximum"));
            this.exclusiveMinimum(m.getBoolean("exclusiveMinimum"));
            this.required(m.getBoolean("required"));
            this.uniqueItems(m.getBoolean("uniqueItems"));
            this.collectionFormat(m.getString("collectionFormat"));
            this.type(m.getString("type"));
            this.format(m.getString("format"));
            this.pattern(m.getString("pattern"));
            this.maximum(m.get("maximum", Number.class));
            this.minimum(m.get("minimum", Number.class));
            this.multipleOf(m.get("multipleOf", Number.class));
            this.maxItems(m.get("maxItems", Long.class));
            this.maxLength(m.get("maxLength", Long.class));
            this.maxProperties(m.get("maxProperties", Long.class));
            this.minItems(m.get("minItems", Long.class));
            this.minLength(m.get("minLength", Long.class));
            this.minProperties(m.get("minProperties", Long.class));
            this.items(m.getObjectMap("items"));
            this.properties(m.getObjectMap("properties"));
            this.additionalProperties(m.getObjectMap("additionalProperties"));
            this.apply(m.getObjectMap("schema", null));
        }
        return this;
    }

    public HttpPartSchemaBuilder name(String value) {
        if (StringUtils.isNotEmpty(value)) {
            this.name = value;
        }
        return this;
    }

    public HttpPartSchemaBuilder codes(int[] value) {
        if (value != null && value.length != 0) {
            for (int v : value) {
                this.code(v);
            }
        }
        return this;
    }

    public HttpPartSchemaBuilder code(int value) {
        if (value != 0) {
            if (this.codes == null) {
                this.codes = new TreeSet<Integer>();
            }
            this.codes.add(value);
        }
        return this;
    }

    public HttpPartSchemaBuilder required(Boolean value) {
        this.required = this.resolve(value, this.required);
        return this;
    }

    public HttpPartSchemaBuilder required(String value) {
        this.required = this.resolve(value, this.required);
        return this;
    }

    public HttpPartSchemaBuilder required() {
        return this.required(true);
    }

    public HttpPartSchemaBuilder type(String value) {
        try {
            if (StringUtils.isNotEmpty(value)) {
                this.type = HttpPartSchema.Type.fromString(value);
            }
        }
        catch (Exception e) {
            throw new ContextRuntimeException("Invalid value ''{0}'' passed in as type value.  Valid values: {1}", new Object[]{value, HttpPartSchema.Type.values()});
        }
        return this;
    }

    public HttpPartSchemaBuilder format(String value) {
        try {
            if (StringUtils.isNotEmpty(value)) {
                this.format = HttpPartSchema.Format.fromString(value);
            }
        }
        catch (Exception e) {
            throw new ContextRuntimeException("Invalid value ''{0}'' passed in as format value.  Valid values: {1}", new Object[]{value, HttpPartSchema.Format.values()});
        }
        return this;
    }

    public HttpPartSchemaBuilder allowEmptyValue(Boolean value) {
        this.allowEmptyValue = this.resolve(value, this.allowEmptyValue);
        return this;
    }

    public HttpPartSchemaBuilder allowEmptyValue(String value) {
        this.allowEmptyValue = this.resolve(value, this.allowEmptyValue);
        return this;
    }

    public HttpPartSchemaBuilder allowEmptyValue() {
        return this.allowEmptyValue(true);
    }

    public HttpPartSchemaBuilder items(HttpPartSchemaBuilder value) {
        if (value != null) {
            this.items = value;
        }
        return this;
    }

    HttpPartSchemaBuilder items(ObjectMap value) {
        if (value != null && !value.isEmpty()) {
            this.items = HttpPartSchema.create().apply(value);
        }
        return this;
    }

    HttpPartSchemaBuilder items(Items value) {
        if (!AnnotationUtils.empty(value)) {
            this.items = HttpPartSchema.create().apply(value);
        }
        return this;
    }

    HttpPartSchemaBuilder items(SubItems value) {
        if (!AnnotationUtils.empty(value)) {
            this.items = HttpPartSchema.create().apply(value);
        }
        return this;
    }

    public HttpPartSchemaBuilder collectionFormat(String value) {
        try {
            if (StringUtils.isNotEmpty(value)) {
                this.collectionFormat = HttpPartSchema.CollectionFormat.fromString(value);
            }
        }
        catch (Exception e) {
            throw new ContextRuntimeException("Invalid value ''{0}'' passed in as collectionFormat value.  Valid values: {1}", new Object[]{value, HttpPartSchema.CollectionFormat.values()});
        }
        return this;
    }

    public HttpPartSchemaBuilder _default(String value) {
        if (value != null) {
            this._default = value;
        }
        return this;
    }

    public HttpPartSchemaBuilder maximum(Number value) {
        if (value != null) {
            this.maximum = value;
        }
        return this;
    }

    public HttpPartSchemaBuilder exclusiveMaximum(Boolean value) {
        this.exclusiveMaximum = this.resolve(value, this.exclusiveMaximum);
        return this;
    }

    public HttpPartSchemaBuilder exclusiveMaximum(String value) {
        this.exclusiveMaximum = this.resolve(value, this.exclusiveMaximum);
        return this;
    }

    public HttpPartSchemaBuilder exclusiveMaximum() {
        return this.exclusiveMaximum(true);
    }

    public HttpPartSchemaBuilder minimum(Number value) {
        if (value != null) {
            this.minimum = value;
        }
        return this;
    }

    public HttpPartSchemaBuilder exclusiveMinimum(Boolean value) {
        this.exclusiveMinimum = this.resolve(value, this.exclusiveMinimum);
        return this;
    }

    public HttpPartSchemaBuilder exclusiveMinimum(String value) {
        this.exclusiveMinimum = this.resolve(value, this.exclusiveMinimum);
        return this;
    }

    public HttpPartSchemaBuilder exclusiveMinimum() {
        return this.exclusiveMinimum(true);
    }

    public HttpPartSchemaBuilder maxLength(Long value) {
        this.maxLength = this.resolve(value, this.maxLength);
        return this;
    }

    public HttpPartSchemaBuilder maxLength(String value) {
        this.maxLength = this.resolve(value, this.maxLength);
        return this;
    }

    public HttpPartSchemaBuilder minLength(Long value) {
        this.minLength = this.resolve(value, this.minLength);
        return this;
    }

    public HttpPartSchemaBuilder minLength(String value) {
        this.minLength = this.resolve(value, this.minLength);
        return this;
    }

    public HttpPartSchemaBuilder pattern(String value) {
        try {
            if (StringUtils.isNotEmpty(value)) {
                this.pattern = Pattern.compile(value);
            }
        }
        catch (Exception e) {
            throw new ContextRuntimeException(e, "Invalid value {0} passed in as pattern value.  Must be a valid regular expression.", value);
        }
        return this;
    }

    public HttpPartSchemaBuilder maxItems(Long value) {
        this.maxItems = this.resolve(value, this.maxItems);
        return this;
    }

    public HttpPartSchemaBuilder maxItems(String value) {
        this.maxItems = this.resolve(value, this.maxItems);
        return this;
    }

    public HttpPartSchemaBuilder minItems(Long value) {
        this.minItems = this.resolve(value, this.minItems);
        return this;
    }

    public HttpPartSchemaBuilder minItems(String value) {
        this.minItems = this.resolve(value, this.minItems);
        return this;
    }

    public HttpPartSchemaBuilder uniqueItems(Boolean value) {
        this.uniqueItems = this.resolve(value, this.uniqueItems);
        return this;
    }

    public HttpPartSchemaBuilder uniqueItems(String value) {
        this.uniqueItems = this.resolve(value, this.uniqueItems);
        return this;
    }

    public HttpPartSchemaBuilder uniqueItems() {
        return this.uniqueItems(true);
    }

    public HttpPartSchemaBuilder skipIfEmpty(Boolean value) {
        this.skipIfEmpty = this.resolve(value, this.skipIfEmpty);
        return this;
    }

    public HttpPartSchemaBuilder skipIfEmpty(String value) {
        this.skipIfEmpty = this.resolve(value, this.skipIfEmpty);
        return this;
    }

    public HttpPartSchemaBuilder skipIfEmpty() {
        return this.skipIfEmpty(true);
    }

    public HttpPartSchemaBuilder _enum(Set<String> value) {
        if (value != null && !value.isEmpty()) {
            this._enum = value;
        }
        return this;
    }

    public HttpPartSchemaBuilder _enum(String ... values) {
        return this._enum(new ASet<String>().appendAll(values));
    }

    public HttpPartSchemaBuilder multipleOf(Number value) {
        if (value != null) {
            this.multipleOf = value;
        }
        return this;
    }

    public HttpPartSchemaBuilder maxProperties(Long value) {
        this.maxProperties = this.resolve(value, this.maxProperties);
        return this;
    }

    public HttpPartSchemaBuilder maxProperties(String value) {
        this.maxProperties = this.resolve(value, this.maxProperties);
        return this;
    }

    public HttpPartSchemaBuilder minProperties(Long value) {
        this.minProperties = this.resolve(value, this.minProperties);
        return this;
    }

    public HttpPartSchemaBuilder minProperties(String value) {
        this.minProperties = this.resolve(value, this.minProperties);
        return this;
    }

    public HttpPartSchemaBuilder property(String key, HttpPartSchemaBuilder value) {
        if (key != null && value != null) {
            if (this.properties == null) {
                this.properties = new LinkedHashMap<String, HttpPartSchemaBuilder>();
            }
            this.properties.put(key, value);
        }
        return this;
    }

    private HttpPartSchemaBuilder properties(ObjectMap value) {
        if (value != null && !value.isEmpty()) {
            for (Map.Entry<String, Object> e : value.entrySet()) {
                this.property(e.getKey(), HttpPartSchema.create().apply((ObjectMap)e.getValue()));
            }
        }
        return this;
    }

    public HttpPartSchemaBuilder additionalProperties(HttpPartSchemaBuilder value) {
        if (value != null) {
            this.additionalProperties = value;
        }
        return this;
    }

    private HttpPartSchemaBuilder additionalProperties(ObjectMap value) {
        if (value != null && !value.isEmpty()) {
            this.additionalProperties = HttpPartSchema.create().apply(value);
        }
        return this;
    }

    public HttpPartSchemaBuilder serializer(Class<? extends HttpPartSerializer> value) {
        if (value != null && value != HttpPartSerializer.Null.class) {
            this.serializer = value;
        }
        return this;
    }

    public HttpPartSchemaBuilder parser(Class<? extends HttpPartParser> value) {
        if (value != null && value != HttpPartParser.Null.class) {
            this.parser = value;
        }
        return this;
    }

    public HttpPartSchemaBuilder noValidate(Boolean value) {
        if (value != null) {
            this.noValidate = value;
        }
        return this;
    }

    public HttpPartSchemaBuilder noValidate() {
        return this.noValidate(true);
    }

    private Boolean resolve(String newValue, Boolean oldValue) {
        return StringUtils.isEmpty(newValue) ? oldValue : Boolean.valueOf(newValue);
    }

    private Boolean resolve(Boolean newValue, Boolean oldValue) {
        return newValue == null ? oldValue : newValue;
    }

    private Long resolve(String newValue, Long oldValue) {
        return StringUtils.isEmpty(newValue) ? oldValue : Long.parseLong(newValue);
    }

    private Long resolve(Long newValue, Long oldValue) {
        return newValue == null || newValue == -1L ? oldValue : newValue;
    }
}

