/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki;

import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.wiki.TestEngine;
import org.apache.wiki.api.core.Acl;
import org.apache.wiki.api.core.AclEntry;
import org.apache.wiki.api.core.Attachment;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.core.Session;
import org.apache.wiki.api.spi.Wiki;
import org.github.jamm.MemoryMeter;
import org.junit.jupiter.api.Test;

class MemoryProfiling {
    MemoryProfiling() {
    }

    @Test
    void memorySize() {
        Properties props = TestEngine.getTestProperties();
        props.put("jspwiki.fileSystemProvider.pageDir", "../jspwiki-wikipages/en/src/main/resources");
        Engine engine = Wiki.engine().find((ServletContext)TestEngine.createServletContext("/test"), TestEngine.getTestProperties());
        Engine engineWithDefaultPages = Wiki.engine().find((ServletContext)TestEngine.createServletContext("/test"), props);
        Page main = Wiki.contents().page(engine, "Main");
        Attachment att = Wiki.contents().attachment(engine, "Main", "file");
        Session session = Wiki.session().guest(engine);
        Acl acl = Wiki.acls().acl();
        AclEntry aclEntry = Wiki.acls().entry();
        MemoryMeter meter = MemoryMeter.builder().build();
        long engineBytes = meter.measureDeep((Object)engine);
        long engineWithDefaultPagesBytes = meter.measureDeep((Object)engineWithDefaultPages);
        long mainBytes = meter.measureDeep((Object)main);
        long attBytes = meter.measureDeep((Object)att);
        long sessionBytes = meter.measureDeep((Object)session);
        long aclBytes = meter.measureDeep((Object)acl);
        long aclEntryBytes = meter.measureDeep((Object)aclEntry);
        System.out.println("");
        System.out.println("===========================================================================================");
        System.out.println("Plain Engine, without pages/attachments, search indexes, references, etc.: " + this.format(engineBytes));
        System.out.println("Engine, with default set of wiki pages: .................................. " + this.format(engineWithDefaultPagesBytes));
        System.out.println("Page: .................................................................... " + this.format(mainBytes - engineBytes));
        System.out.println("Attachment: .............................................................. " + this.format(attBytes - engineBytes));
        System.out.println("Guest session on plain engine: ........................................... " + this.format(sessionBytes - engineBytes));
        System.out.println("Acl: ..................................................................... " + this.format(aclBytes));
        System.out.println("Acl entry: ............................................................... " + this.format(aclEntryBytes));
        System.out.println("-------------------------------------------------------------------------------------------");
        System.out.println("");
    }

    String format(long bytes) {
        return String.format("%,10d bytes", bytes);
    }
}

