/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy.writercache;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.apache.lucene.facet.taxonomy.FacetLabel;

class NameIntCacheLRU {
    private HashMap<Object, Integer> cache;
    long nMisses = 0L;
    long nHits = 0L;
    private int maxCacheSize;

    NameIntCacheLRU(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
        this.createCache(maxCacheSize);
    }

    public int getMaxSize() {
        return this.maxCacheSize;
    }

    public int getSize() {
        return this.cache.size();
    }

    private void createCache(int maxSize) {
        this.cache = maxSize < Integer.MAX_VALUE ? new LinkedHashMap<Object, Integer>(1000, 0.7f, true) : new HashMap(1000, 0.7f);
    }

    Integer get(FacetLabel name) {
        Integer res = this.cache.get(this.key(name));
        if (res == null) {
            ++this.nMisses;
        } else {
            ++this.nHits;
        }
        return res;
    }

    Object key(FacetLabel name) {
        return name;
    }

    Object key(FacetLabel name, int prefixLen) {
        return name.subpath(prefixLen);
    }

    boolean put(FacetLabel name, Integer val) {
        this.cache.put(this.key(name), val);
        return this.isCacheFull();
    }

    boolean put(FacetLabel name, int prefixLen, Integer val) {
        this.cache.put(this.key(name, prefixLen), val);
        return this.isCacheFull();
    }

    private boolean isCacheFull() {
        return this.cache.size() > this.maxCacheSize;
    }

    void clear() {
        this.cache.clear();
    }

    String stats() {
        return "#miss=" + this.nMisses + " #hit=" + this.nHits;
    }

    boolean makeRoomLRU() {
        if (!this.isCacheFull()) {
            return false;
        }
        int n = this.cache.size() - (int)(2L * (long)this.maxCacheSize / 3L);
        if (n <= 0) {
            return false;
        }
        Iterator<Object> it = this.cache.keySet().iterator();
        for (int i = 0; i < n && it.hasNext(); ++i) {
            it.next();
            it.remove();
        }
        return true;
    }
}

