/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.util.Map;
import java.util.stream.Stream;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.json.stream.JsonParser;
import org.apache.johnzon.core.BufferStrategy;
import org.apache.johnzon.core.JohnzonJsonParser;
import org.apache.johnzon.core.JsonLongImpl;
import org.apache.johnzon.core.JsonNumberImpl;
import org.apache.johnzon.core.JsonReaderImpl;
import org.apache.johnzon.core.JsonStringImpl;

public abstract class JohnzonJsonParserImpl
implements JohnzonJsonParser {
    protected abstract boolean isInArray();

    protected abstract BufferStrategy.BufferProvider<char[]> getCharArrayProvider();

    public JsonObject getObject() {
        JsonParser.Event current = this.current();
        if (current != JsonParser.Event.START_OBJECT) {
            throw new IllegalStateException(current + " doesn't support getObject()");
        }
        JsonReaderImpl jsonReader = new JsonReaderImpl(this, true, this.getCharArrayProvider());
        return jsonReader.readObject();
    }

    public JsonArray getArray() {
        JsonParser.Event current = this.current();
        if (current != JsonParser.Event.START_ARRAY) {
            throw new IllegalStateException(current + " doesn't support getArray()");
        }
        JsonReaderImpl jsonReader = new JsonReaderImpl(this, true, this.getCharArrayProvider());
        return jsonReader.readArray();
    }

    public JsonValue getValue() {
        JsonParser.Event current = this.current();
        switch (current) {
            case START_ARRAY: 
            case START_OBJECT: {
                JsonReaderImpl jsonReader = new JsonReaderImpl(this, true, this.getCharArrayProvider());
                return jsonReader.readValue();
            }
            case VALUE_TRUE: {
                return JsonValue.TRUE;
            }
            case VALUE_FALSE: {
                return JsonValue.FALSE;
            }
            case VALUE_NULL: {
                return JsonValue.NULL;
            }
            case VALUE_STRING: 
            case KEY_NAME: {
                return new JsonStringImpl(this.getString());
            }
            case VALUE_NUMBER: {
                if (this.isIntegralNumber()) {
                    return new JsonLongImpl(this.getLong());
                }
                return new JsonNumberImpl(this.getBigDecimal());
            }
        }
        throw new IllegalStateException(current + " doesn't support getValue()");
    }

    public void skipObject() {
        int level = 1;
        do {
            JsonParser.Event event;
            if ((event = this.next()) == JsonParser.Event.START_OBJECT) {
                ++level;
                continue;
            }
            if (event != JsonParser.Event.END_OBJECT) continue;
            --level;
        } while (level > 0 && this.hasNext());
    }

    public void skipArray() {
        if (this.isInArray()) {
            int level = 1;
            do {
                JsonParser.Event event;
                if ((event = this.next()) == JsonParser.Event.START_ARRAY) {
                    ++level;
                    continue;
                }
                if (event != JsonParser.Event.END_ARRAY) continue;
                --level;
            } while (level > 0 && this.hasNext());
        }
    }

    public Stream<JsonValue> getArrayStream() {
        return this.getArray().stream();
    }

    public Stream<Map.Entry<String, JsonValue>> getObjectStream() {
        return this.getObject().entrySet().stream();
    }

    public Stream<JsonValue> getValueStream() {
        JsonParser.Event current = this.current();
        if (current == JsonParser.Event.START_ARRAY) {
            return this.getArrayStream();
        }
        if (current == JsonParser.Event.START_OBJECT) {
            return this.getObject().values().stream();
        }
        throw new IllegalStateException(current + " doesn't support getValueStream");
    }
}

