/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.text;

import com.github.weisj.darklaf.icons.EmptyIcon;
import com.github.weisj.darklaf.ui.text.DarkTextFieldUI;
import com.github.weisj.darklaf.ui.text.bridge.DarkPasswordFieldUIBridge;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.JTextComponent;

public class DarkPasswordFieldUI
extends DarkPasswordFieldUIBridge {
    protected static final String KEY_PREFIX = "JPasswordField.";
    public static final String KEY_SHOW_VIEW_BUTTON = "JPasswordField.showViewIcon";
    protected Icon show;
    protected Icon showPressed;
    protected int borderSize;
    private char echo_dot = (char)42;
    private boolean showTriggered = false;

    public static ComponentUI createUI(JComponent c) {
        return new DarkPasswordFieldUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.show = UIManager.getIcon("PasswordField.show.icon");
        this.showPressed = UIManager.getIcon("PasswordField.showPressed.icon");
    }

    @Override
    protected JPopupMenu createPopupMenu(JTextComponent textComponent) {
        return null;
    }

    @Override
    protected boolean doPaintLeftIcon(JTextComponent c) {
        return false;
    }

    @Override
    protected boolean doPaintRightIcon(JTextComponent c) {
        return super.doPaintRightIcon(c) || DarkPasswordFieldUI.hasShowIcon(c);
    }

    @Override
    protected Icon getLeftIcon(JTextComponent c) {
        return EmptyIcon.create((int)0);
    }

    @Override
    protected Icon getRightIcon(JTextComponent c) {
        return DarkPasswordFieldUI.hasShowIcon(c) ? this.getShowIcon(c) : super.getRightIcon(c);
    }

    protected Icon getShowIcon(JTextComponent c) {
        return this.showTriggered || !this.editor.isEditable() || !this.editor.isEditable() ? this.showPressed : this.show;
    }

    public static boolean hasShowIcon(Component c) {
        return PropertyUtil.getBooleanProperty((Component)c, (String)KEY_SHOW_VIEW_BUTTON);
    }

    private boolean isOverEye(Point p) {
        return !this.passwordEmpty() && DarkTextFieldUI.isOver(this.getRightIconPos(), this.getShowIcon(this.editor), p);
    }

    protected boolean passwordEmpty() {
        JPasswordField c = (JPasswordField)this.getComponent();
        char[] pw = c.getPassword();
        boolean empty = pw.length == 0;
        Arrays.fill(pw, '\u0000');
        return empty;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        if (c instanceof JPasswordField) {
            this.echo_dot = ((JPasswordField)c).getEchoChar();
        }
    }

    @Override
    protected DarkTextFieldUI.ClickAction getActionUnder(Point p) {
        DarkTextFieldUI.ClickAction action = super.getActionUnder(p);
        if (this.isOverEye(p) && DarkPasswordFieldUI.hasShowIcon(this.editor)) {
            action = DarkTextFieldUI.ClickAction.RIGHT_ACTION;
        }
        return action;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (DarkPasswordFieldUI.hasShowIcon(this.getComponent())) {
            return;
        }
        super.mouseClicked(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (DarkPasswordFieldUI.hasShowIcon(this.editor) && this.isOverEye(e.getPoint())) {
            ((JPasswordField)this.getComponent()).setEchoChar('\u0000');
            this.showTriggered = true;
            this.getComponent().repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.showTriggered) {
            ((JPasswordField)this.getComponent()).setEchoChar(this.echo_dot);
            this.showTriggered = false;
            this.getComponent().repaint();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        String key = evt.getPropertyName();
        if (KEY_SHOW_VIEW_BUTTON.equals(key)) {
            this.editor.doLayout();
            Container parent = this.editor.getParent();
            if (parent instanceof JComponent) {
                ((Component)parent).doLayout();
            }
            this.editor.repaint();
        }
    }
}

