/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.tcp.sampler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import org.apache.jmeter.protocol.tcp.sampler.AbstractTCPClient;
import org.apache.jmeter.protocol.tcp.sampler.ReadException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.util.JOrphanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryTCPClientImpl
extends AbstractTCPClient {
    private static final Logger log = LoggerFactory.getLogger(BinaryTCPClientImpl.class);
    private static final int EOM_INT = JMeterUtils.getPropDefault((String)"tcp.BinaryTCPClient.eomByte", (int)1000);

    public BinaryTCPClientImpl() {
        this.setEolByte(EOM_INT);
        if (this.useEolByte) {
            log.info("Using eomByte={}", (Object)this.eolByte);
        }
    }

    public static byte[] hexStringToByteArray(String hexEncodedBinary) {
        if (hexEncodedBinary.length() % 2 == 0) {
            char[] sc = hexEncodedBinary.toCharArray();
            byte[] ba = new byte[sc.length / 2];
            for (int i = 0; i < ba.length; ++i) {
                int nibble0 = Character.digit(sc[i * 2], 16);
                int nibble1 = Character.digit(sc[i * 2 + 1], 16);
                if (nibble0 == -1 || nibble1 == -1) {
                    throw new IllegalArgumentException("Hex-encoded binary string contains an invalid hex digit in '" + sc[i * 2] + sc[i * 2 + 1] + "'");
                }
                ba[i] = (byte)(nibble0 << 4 | nibble1);
            }
            return ba;
        }
        throw new IllegalArgumentException("Hex-encoded binary string contains an uneven no. of digits");
    }

    @Override
    public void write(OutputStream os, String hexEncodedBinary) throws IOException {
        os.write(BinaryTCPClientImpl.hexStringToByteArray(hexEncodedBinary));
        os.flush();
        if (log.isDebugEnabled()) {
            log.debug("Wrote: " + hexEncodedBinary);
        }
    }

    @Override
    public void write(OutputStream os, InputStream is) {
        throw new UnsupportedOperationException("Method not supported for Length-Prefixed data.");
    }

    @Override
    @Deprecated
    public String read(InputStream is) throws ReadException {
        log.warn("Deprecated method, use read(is, sampleResult) instead");
        return this.read(is, new SampleResult());
    }

    @Override
    public String read(InputStream is, SampleResult sampleResult) throws ReadException {
        ByteArrayOutputStream w = new ByteArrayOutputStream();
        try {
            byte[] buffer = new byte[4096];
            int x = 0;
            boolean first = true;
            while ((x = is.read(buffer)) > -1) {
                if (first) {
                    sampleResult.latencyEnd();
                    first = false;
                }
                w.write(buffer, 0, x);
                if (!this.useEolByte || buffer[x - 1] != this.eolByte) continue;
                break;
            }
        }
        catch (SocketTimeoutException e) {
            if (this.useEolByte) {
                throw new ReadException("Socket timed out while looking for EOM", e, JOrphanUtils.baToHexString((byte[])w.toByteArray()));
            }
            log.debug("Ignoring SocketTimeoutException, as we are not looking for EOM", (Throwable)e);
        }
        catch (IOException e) {
            throw new ReadException("Problems while trying to read", e, JOrphanUtils.baToHexString((byte[])w.toByteArray()));
        }
        String hexString = JOrphanUtils.baToHexString((byte[])w.toByteArray());
        if (log.isDebugEnabled()) {
            log.debug("Read: {}\n{}", (Object)w.size(), (Object)hexString);
        }
        return hexString;
    }
}

