/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.similarities;

import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.similarities.BasicModel;
import org.apache.lucene.search.similarities.BasicStats;
import org.apache.lucene.search.similarities.SimilarityBase;

public class BasicModelIne
extends BasicModel {
    @Override
    public final double score(BasicStats stats, double tfn, double aeTimes1pTfn) {
        long N = stats.getNumberOfDocuments();
        long F2 = stats.getTotalTermFreq();
        double ne = (double)N * (1.0 - Math.pow((double)(N - 1L) / (double)N, F2));
        double A = SimilarityBase.log2((double)(N + 1L) / (ne + 0.5));
        return A * aeTimes1pTfn * (1.0 - 1.0 / (1.0 + tfn));
    }

    @Override
    public Explanation explain(BasicStats stats, double tfn, double aeTimes1pTfn) {
        double F2 = stats.getTotalTermFreq();
        double N = stats.getNumberOfDocuments();
        double ne = N * (1.0 - Math.pow((N - 1.0) / N, F2));
        Explanation explNe = Explanation.match((Number)Float.valueOf((float)ne), "ne, computed as N * (1 - Math.pow((N - 1) / N, F)) from:", Explanation.match((Number)Float.valueOf((float)F2), "F, total number of occurrences of term across all docs", new Explanation[0]), Explanation.match((Number)Float.valueOf((float)N), "N, total number of documents with field", new Explanation[0]));
        return Explanation.match((Number)Float.valueOf((float)(this.score(stats, tfn, aeTimes1pTfn) * (1.0 + tfn) / aeTimes1pTfn)), this.getClass().getSimpleName() + ", computed as tfn * log2((N + 1) / (ne + 0.5)) from:", Explanation.match((Number)Float.valueOf((float)tfn), "tfn, normalized term frequency", new Explanation[0]), explNe);
    }

    @Override
    public String toString() {
        return "I(ne)";
    }
}

