/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.lib;

import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.atlas.lib.Pool;
import org.apache.jena.atlas.lib.PoolBase;
import org.apache.jena.atlas.lib.PoolSync;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.sparql.util.NodeUtils;
import org.apache.jena.tdb1.TDB1Exception;
import org.apache.jena.tdb1.base.objectfile.ObjectFile;
import org.apache.jena.tdb1.base.record.Record;
import org.apache.jena.tdb1.store.Hash;
import org.apache.jena.tdb1.store.NodeId;
import org.apache.jena.tdb1.store.NodeType;
import org.apache.jena.tdb1.store.nodetable.NodeTable;
import org.apache.jena.tdb1.store.nodetable.Nodec;
import org.apache.jena.tdb1.store.nodetable.NodecSSE;

public class NodeLib {
    private static Nodec nodec = new NodecSSE();
    private static int InitialPoolSize = 5;
    private static Pool<MessageDigest> digesters = PoolSync.create(new PoolBase());

    public static long encodeStore(Node node, ObjectFile file) {
        return NodeLib.encodeStore(node, file, null);
    }

    public static long encodeStore(Node node, ObjectFile file, ByteBuffer bb) {
        int maxSize = nodec.maxSize(node);
        if (bb == null) {
            return NodeLib.allocEncodeWrite(node, file, maxSize);
        }
        if (bb.capacity() < maxSize) {
            return NodeLib.allocEncodeWrite(node, file, maxSize);
        }
        bb.clear();
        return NodeLib.encodeWrite(node, file, bb);
    }

    private static long allocEncodeWrite(Node node, ObjectFile file, int maxSize) {
        ByteBuffer bb = ByteBuffer.allocate(maxSize);
        return NodeLib.encodeWrite(node, file, bb);
    }

    private static long encodeWrite(Node node, ObjectFile file, ByteBuffer bb) {
        int len = nodec.encode(node, bb, null);
        long x = file.write(bb);
        return x;
    }

    public static Node fetchDecode(long id, ObjectFile file) {
        ByteBuffer bb = file.read(id);
        if (bb == null) {
            return null;
        }
        return NodeLib.decode(bb);
    }

    public static ByteBuffer encode(Node node) {
        int maxSize = nodec.maxSize(node);
        ByteBuffer bb = ByteBuffer.allocate(maxSize);
        int len = nodec.encode(node, bb, null);
        bb.limit(len);
        bb.position(0);
        return bb;
    }

    public static Node decode(ByteBuffer bb) {
        bb.position(0);
        Node n = nodec.decode(bb, null);
        return n;
    }

    public static Hash hash(Node n) {
        Hash h = new Hash(16);
        NodeLib.setHash(h, n);
        return h;
    }

    public static void setHash(Hash h, Node n) {
        NodeType nt = NodeType.lookup(n);
        switch (nt) {
            case URI: {
                NodeLib.hash(h, n.getURI(), null, null, nt);
                return;
            }
            case BNODE: {
                NodeLib.hash(h, n.getBlankNodeLabel(), null, null, nt);
                return;
            }
            case LITERAL: {
                String dt = n.getLiteralDatatypeURI();
                if (NodeUtils.isSimpleString(n) || NodeUtils.isLangString(n)) {
                    dt = null;
                }
                NodeLib.hash(h, n.getLiteralLexicalForm(), n.getLiteralLanguage(), dt, nt);
                return;
            }
            case TRIPLETERM: {
                String lex = NodeFmtLib.strNT(n);
                NodeLib.hash(h, lex, null, null, nt);
                return;
            }
            case OTHER: {
                throw new TDB1Exception("Attempt to hash something strange: " + String.valueOf(n));
            }
        }
        throw new TDB1Exception("NodeType broken: " + String.valueOf(n));
    }

    private static MessageDigest allocDigest() {
        try {
            MessageDigest disgest = digesters.get();
            if (disgest == null) {
                disgest = MessageDigest.getInstance("MD5");
            }
            return disgest;
        }
        catch (NoSuchAlgorithmException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    private static void deallocDigest(MessageDigest digest) {
        digest.reset();
        digesters.put(digest);
    }

    private static void hash(Hash h, String lex, String lang, String datatype, NodeType nodeType) {
        if (datatype == null) {
            datatype = "";
        }
        if (lang == null) {
            lang = "";
        }
        String toHash = lex + "|" + lang + "|" + datatype + "|" + nodeType.getName();
        try {
            MessageDigest digest = NodeLib.allocDigest();
            digest.update(Bytes.string2bytes(toHash));
            if (h.getLen() == 16) {
                digest.digest(h.getBytes(), 0, 16);
            } else {
                byte[] b = digest.digest();
                System.arraycopy(b, 0, h.getBytes(), 0, h.getLen());
            }
            NodeLib.deallocDigest(digest);
            return;
        }
        catch (DigestException ex) {
            Log.error(NodeLib.class, "DigestException", ex);
            return;
        }
    }

    public static NodeId getNodeId(Record r, int idx) {
        return NodeId.create(Bytes.getLong(r.getKey(), idx));
    }

    public static Node termOrAny(Node node) {
        if (node == null || node.isVariable()) {
            return Node.ANY;
        }
        return node;
    }

    public static Iterator<Node> nodes(NodeTable nodeTable, Iterator<NodeId> iter) {
        return Iter.map(iter, nodeTable::getNodeForNodeId);
    }

    static {
        try {
            for (int i = 0; i < InitialPoolSize; ++i) {
                digesters.put(MessageDigest.getInstance("MD5"));
            }
        }
        catch (NoSuchAlgorithmException e2) {
            e2.printStackTrace();
        }
    }
}

