/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.json.impl;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.json.JsonArray;
import org.apache.activemq.artemis.json.JsonNumber;
import org.apache.activemq.artemis.json.JsonObject;
import org.apache.activemq.artemis.json.JsonString;
import org.apache.activemq.artemis.json.JsonValue;
import org.apache.activemq.artemis.json.impl.JsonValueImpl;

public class JsonObjectImpl
extends JsonValueImpl
implements JsonObject {
    private final org.apache.activemq.artemis.commons.shaded.json.JsonObject rawObject;

    public org.apache.activemq.artemis.commons.shaded.json.JsonObject getRawObject() {
        return this.rawObject;
    }

    public JsonObjectImpl(org.apache.activemq.artemis.commons.shaded.json.JsonObject rawObject) {
        super(rawObject);
        this.rawObject = rawObject;
    }

    @Override
    public JsonArray getJsonArray(String name) {
        return (JsonArray)this.wrap(this.rawObject.getJsonArray(name));
    }

    @Override
    public JsonObject getJsonObject(String name) {
        return (JsonObject)this.wrap(this.rawObject.getJsonObject(name));
    }

    @Override
    public JsonNumber getJsonNumber(String name) {
        return (JsonNumber)this.wrap(this.rawObject.getJsonNumber(name));
    }

    @Override
    public JsonString getJsonString(String name) {
        return (JsonString)this.wrap(this.rawObject.getJsonString(name));
    }

    @Override
    public String getString(String name) {
        return this.rawObject.getString(name);
    }

    @Override
    public String getString(String name, String defaultValue) {
        return this.rawObject.getString(name, defaultValue);
    }

    @Override
    public int getInt(String name) {
        return this.rawObject.getInt(name);
    }

    @Override
    public int getInt(String name, int defaultValue) {
        return this.rawObject.getInt(name, defaultValue);
    }

    @Override
    public boolean getBoolean(String name) {
        return this.rawObject.getBoolean(name);
    }

    @Override
    public boolean getBoolean(String name, boolean defaultValue) {
        return this.rawObject.getBoolean(name, defaultValue);
    }

    @Override
    public boolean isNull(String name) {
        return this.rawObject.isNull(name);
    }

    @Override
    public int size() {
        return this.rawObject.size();
    }

    @Override
    public boolean isEmpty() {
        return this.rawObject.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.rawObject.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.rawObject.containsValue(value);
    }

    @Override
    public JsonValue get(Object key) {
        return this.wrap((org.apache.activemq.artemis.commons.shaded.json.JsonValue)this.rawObject.get(key));
    }

    @Override
    public JsonValue put(String key, JsonValue value) {
        if (!(value instanceof JsonValueImpl)) {
            throw new UnsupportedOperationException();
        }
        org.apache.activemq.artemis.commons.shaded.json.JsonValue rawValue = this.rawObject.put(key, ((JsonValueImpl)value).getRawValue());
        return rawValue != null ? this.wrap(rawValue) : null;
    }

    @Override
    public JsonValue remove(Object key) {
        org.apache.activemq.artemis.commons.shaded.json.JsonValue rawValue = (org.apache.activemq.artemis.commons.shaded.json.JsonValue)this.rawObject.remove(key);
        return rawValue != null ? this.wrap(rawValue) : null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends JsonValue> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.rawObject.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.rawObject.keySet();
    }

    @Override
    public Collection<JsonValue> values() {
        return new AbstractCollection<JsonValue>(){

            @Override
            public Iterator<JsonValue> iterator() {
                return new Iterator<JsonValue>(){
                    private Iterator<org.apache.activemq.artemis.commons.shaded.json.JsonValue> rawIterator;
                    {
                        this.rawIterator = JsonObjectImpl.this.rawObject.values().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.rawIterator.hasNext();
                    }

                    @Override
                    public JsonValue next() {
                        return JsonObjectImpl.this.wrap(this.rawIterator.next());
                    }
                };
            }

            @Override
            public int size() {
                return JsonObjectImpl.this.rawObject.size();
            }
        };
    }

    @Override
    public Set<Map.Entry<String, JsonValue>> entrySet() {
        return new AbstractSet<Map.Entry<String, JsonValue>>(){

            @Override
            public Iterator<Map.Entry<String, JsonValue>> iterator() {
                return new Iterator<Map.Entry<String, JsonValue>>(){
                    private Iterator<Map.Entry<String, org.apache.activemq.artemis.commons.shaded.json.JsonValue>> rawIterator;
                    {
                        this.rawIterator = JsonObjectImpl.this.rawObject.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.rawIterator.hasNext();
                    }

                    @Override
                    public Map.Entry<String, JsonValue> next() {
                        Map.Entry<String, org.apache.activemq.artemis.commons.shaded.json.JsonValue> rawEntry = this.rawIterator.next();
                        return rawEntry != null ? new AbstractMap.SimpleEntry<String, JsonValue>(rawEntry.getKey(), JsonObjectImpl.this.wrap(rawEntry.getValue())) : null;
                    }
                };
            }

            @Override
            public int size() {
                return JsonObjectImpl.this.rawObject.size();
            }
        };
    }
}

