/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeUtils;
import org.apache.mailet.Mail;
import org.apache.mailet.MatcherConfig;
import org.apache.mailet.base.GenericMatcher;

public class HasMailAttributeWithValueRegex
extends GenericMatcher {
    private AttributeName attributeName;
    private Pattern pattern = null;

    public String getMatcherInfo() {
        return "Has Mail Attribute Value Matcher";
    }

    public void init(MatcherConfig conf) throws MessagingException {
        String condition = conf.getCondition();
        int idx = condition.indexOf(44);
        if (idx != -1) {
            this.attributeName = AttributeName.of((String)condition.substring(0, idx).trim());
            String patternString = condition.substring(idx + 1).trim();
            try {
                this.pattern = Pattern.compile(patternString);
            }
            catch (PatternSyntaxException mpe) {
                throw new MessagingException("Malformed pattern: " + patternString, (Exception)mpe);
            }
        } else {
            throw new MessagingException("malformed condition for HasMailAttributeWithValueRegex. must be of the form: attr,regex");
        }
        super.init(conf);
    }

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        return AttributeUtils.getAttributeValueFromMail((Mail)mail, (AttributeName)this.attributeName).filter(obj -> this.pattern.matcher(obj.toString()).matches()).map(any -> mail.getRecipients()).orElse(null);
    }
}

