/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeUtils;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;

public class HasMailAttributeWithValue
extends GenericMatcher {
    private AttributeName fieldAttributeName;
    private String fieldAttributeValue;

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        return AttributeUtils.getAttributeValueFromMail((Mail)mail, (AttributeName)this.fieldAttributeName).filter(attributeValue -> attributeValue.toString().trim().equals(this.fieldAttributeValue)).map(any -> mail.getRecipients()).orElse(null);
    }

    public void init() throws MessagingException {
        String condition = this.getCondition().trim();
        int commaPosition = condition.indexOf(44);
        if (-1 == commaPosition) {
            throw new MessagingException("Syntax Error. Missing ','.");
        }
        if (0 == commaPosition) {
            throw new MessagingException("Syntax Error. Missing attribute name.");
        }
        this.fieldAttributeName = AttributeName.of((String)condition.substring(0, commaPosition).trim());
        this.fieldAttributeValue = condition.substring(commaPosition + 1).trim();
    }

    public String getMatcherInfo() {
        return "Has Mail Attribute With Value Matcher";
    }
}

