/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory;

import java.time.Clock;
import javax.inject.Inject;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.inmemory.mail.InMemoryAnnotationMapper;
import org.apache.james.mailbox.inmemory.mail.InMemoryAttachmentMapper;
import org.apache.james.mailbox.inmemory.mail.InMemoryMailboxMapper;
import org.apache.james.mailbox.inmemory.mail.InMemoryMessageIdMapper;
import org.apache.james.mailbox.inmemory.mail.InMemoryMessageMapper;
import org.apache.james.mailbox.inmemory.mail.InMemoryModSeqProvider;
import org.apache.james.mailbox.inmemory.mail.InMemoryUidProvider;
import org.apache.james.mailbox.inmemory.user.InMemorySubscriptionMapper;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.mail.AnnotationMapper;
import org.apache.james.mailbox.store.mail.AttachmentMapper;
import org.apache.james.mailbox.store.mail.AttachmentMapperFactory;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.MessageIdMapper;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.user.SubscriptionMapper;

public class InMemoryMailboxSessionMapperFactory
extends MailboxSessionMapperFactory
implements AttachmentMapperFactory {
    private final MailboxMapper mailboxMapper = new InMemoryMailboxMapper();
    private final InMemoryMessageMapper messageMapper;
    private final InMemoryMessageIdMapper messageIdMapper;
    private final SubscriptionMapper subscriptionMapper;
    private final AttachmentMapper attachmentMapper;
    private final AnnotationMapper annotationMapper;
    private final InMemoryUidProvider uidProvider = new InMemoryUidProvider();
    private final InMemoryModSeqProvider modSeqProvider = new InMemoryModSeqProvider();

    @Inject
    public InMemoryMailboxSessionMapperFactory(Clock clock) {
        this.messageMapper = new InMemoryMessageMapper(null, this.uidProvider, this.modSeqProvider, clock);
        this.messageIdMapper = new InMemoryMessageIdMapper(this.mailboxMapper, this.messageMapper);
        this.subscriptionMapper = new InMemorySubscriptionMapper();
        this.attachmentMapper = new InMemoryAttachmentMapper();
        this.annotationMapper = new InMemoryAnnotationMapper();
    }

    public MailboxMapper createMailboxMapper(MailboxSession session) {
        return this.mailboxMapper;
    }

    public InMemoryMessageMapper createMessageMapper(MailboxSession session) {
        return this.messageMapper;
    }

    public MessageIdMapper createMessageIdMapper(MailboxSession session) {
        return this.messageIdMapper;
    }

    public SubscriptionMapper createSubscriptionMapper(MailboxSession session) {
        return this.subscriptionMapper;
    }

    public AttachmentMapper createAttachmentMapper(MailboxSession session) {
        return this.attachmentMapper;
    }

    public void deleteAll() throws MailboxException {
        ((InMemoryMailboxMapper)this.mailboxMapper).deleteAll().block();
        this.messageMapper.deleteAll();
        ((InMemorySubscriptionMapper)this.subscriptionMapper).deleteAll();
    }

    public AnnotationMapper createAnnotationMapper(MailboxSession session) {
        return this.annotationMapper;
    }

    public UidProvider getUidProvider() {
        return this.uidProvider;
    }

    public ModSeqProvider getModSeqProvider() {
        return this.modSeqProvider;
    }

    public AttachmentMapper getAttachmentMapper(MailboxSession session) {
        return this.attachmentMapper;
    }
}

