/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.request.SetACLRequest;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.exception.UnsupportedRightException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.FunctionalUtils;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class SetACLProcessor
extends AbstractMailboxProcessor<SetACLRequest>
implements CapabilityImplementingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SetACLProcessor.class);
    private static final List<Capability> CAPABILITIES = ImmutableList.of((Object)ImapConstants.SUPPORTS_ACL);

    @Inject
    public SetACLProcessor(MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(SetACLRequest.class, mailboxManager, factory, metricFactory);
    }

    @Override
    protected Mono<Void> processRequestReactive(SetACLRequest request, ImapSession session, ImapProcessor.Responder responder) {
        MailboxManager mailboxManager = this.getMailboxManager();
        MailboxSession mailboxSession = session.getMailboxSession();
        String mailboxName = request.getMailboxName();
        String identifier = request.getIdentifier();
        MailboxPath mailboxPath = PathConverter.forSession(session).buildFullPath(mailboxName);
        return this.checkLookupRight(request, responder, mailboxManager, mailboxSession, mailboxPath).filter(FunctionalUtils.identityPredicate()).flatMap(hasLookupRight -> this.checkAdminRight(request, responder, mailboxManager, mailboxSession, mailboxName, mailboxPath)).filter(FunctionalUtils.identityPredicate()).flatMap(hasAdminRight -> this.applyRight(mailboxManager, mailboxSession, identifier, request, mailboxPath).then(Mono.fromRunnable(() -> this.okComplete(request, responder))).then()).onErrorResume(UnsupportedRightException.class, error -> Mono.fromRunnable(() -> this.taggedBad(request, responder, new HumanReadableText("org.apache.james.imap.UNSUPPORTED_RIGHT", "The {0} right is not supported.", Character.valueOf(error.getUnsupportedRight()))))).onErrorResume(MailboxNotFoundException.class, error -> Mono.fromRunnable(() -> this.no(request, responder, HumanReadableText.MAILBOX_NOT_FOUND))).doOnEach(ReactorUtils.logOnError(MailboxException.class, e -> LOGGER.error("{} failed for mailbox {}", new Object[]{request.getCommand().getName(), mailboxName, e}))).onErrorResume(MailboxException.class, error -> Mono.fromRunnable(() -> this.no(request, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING)));
    }

    private Pair<MailboxACL.Rfc4314Rights, MailboxACL.EditMode> parsingRightAndEditMode(SetACLRequest request) throws UnsupportedRightException {
        MailboxACL.EditMode editMode = MailboxACL.EditMode.REPLACE;
        String rights = request.getRights();
        if (StringUtils.isNotEmpty((CharSequence)rights)) {
            switch (rights.charAt(0)) {
                case '+': {
                    editMode = MailboxACL.EditMode.ADD;
                    rights = rights.substring(1);
                    break;
                }
                case '-': {
                    editMode = MailboxACL.EditMode.REMOVE;
                    rights = rights.substring(1);
                }
            }
        }
        return Pair.of((Object)MailboxACL.Rfc4314Rights.fromSerializedRfc4314Rights((String)rights), (Object)editMode);
    }

    private Mono<Void> applyRight(MailboxManager mailboxManager, MailboxSession mailboxSession, String identifier, SetACLRequest request, MailboxPath mailboxPath) {
        return Mono.fromCallable(() -> this.parsingRightAndEditMode(request)).flatMap(rightAndEditMode -> Mono.from((Publisher)mailboxManager.applyRightsCommandReactive(mailboxPath, MailboxACL.command().key(MailboxACL.EntryKey.deserialize((String)identifier)).mode((MailboxACL.EditMode)rightAndEditMode.getRight()).rights((MailboxACL.Rfc4314Rights)rightAndEditMode.getLeft()).build(), mailboxSession)));
    }

    private Mono<Boolean> checkAdminRight(SetACLRequest request, ImapProcessor.Responder responder, MailboxManager mailboxManager, MailboxSession mailboxSession, String mailboxName, MailboxPath mailboxPath) {
        return Mono.from((Publisher)mailboxManager.hasRightReactive(mailboxPath, MailboxACL.Right.Administer, mailboxSession)).doOnNext(hasRight -> {
            if (!hasRight.booleanValue()) {
                this.no(request, responder, new HumanReadableText("org.apache.james.imap.UNSUFFICIENT_RIGHTS", "You need the {0} right to perform command {1} on mailbox {2}.", MailboxACL.Right.Administer.toString(), request.getCommand().getName(), mailboxName));
            }
        });
    }

    private Mono<Boolean> checkLookupRight(SetACLRequest request, ImapProcessor.Responder responder, MailboxManager mailboxManager, MailboxSession mailboxSession, MailboxPath mailboxPath) {
        return Mono.from((Publisher)mailboxManager.hasRightReactive(mailboxPath, MailboxACL.Right.Lookup, mailboxSession)).doOnNext(hasRight -> {
            if (!hasRight.booleanValue()) {
                this.no(request, responder, HumanReadableText.MAILBOX_NOT_FOUND);
            }
        });
    }

    @Override
    public List<Capability> getImplementedCapabilities(ImapSession session) {
        return CAPABILITIES;
    }

    @Override
    protected MDCBuilder mdc(SetACLRequest request) {
        return MDCBuilder.create().addToContext("action", "SET_ACL").addToContext("mailbox", request.getMailboxName()).addToContext("identifier", request.getIdentifier()).addToContext("rights", request.getRights());
    }
}

