/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.ldap;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.core.Domain;
import org.apache.james.core.Username;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.api.model.User;
import org.apache.james.user.ldap.LdapRepositoryConfiguration;
import org.apache.james.user.ldap.ReadOnlyLDAPUser;
import org.apache.james.user.lib.UsersDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyLDAPUsersDAO
implements UsersDAO,
Configurable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadOnlyLDAPUsersDAO.class);
    private static final TrustManager DUMMY_TRUST_MANAGER = new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }
    };
    private LdapRepositoryConfiguration ldapConfiguration;
    private LDAPConnectionPool ldapConnectionPool;
    private Optional<Filter> userExtraFilter;
    private Filter objectClassFilter;
    private Filter listingFilter;

    @Inject
    public ReadOnlyLDAPUsersDAO() {
    }

    public void configure(HierarchicalConfiguration<ImmutableNode> configuration) throws ConfigurationException {
        this.configure(LdapRepositoryConfiguration.from(configuration));
    }

    public void configure(LdapRepositoryConfiguration configuration) {
        this.ldapConfiguration = configuration;
    }

    public void init() throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(this.getClass().getName() + ".init()\nLDAP host: " + this.ldapConfiguration.getLdapHost() + "\nUser baseDN: " + this.ldapConfiguration.getUserBase() + "\nuserIdAttribute: " + this.ldapConfiguration.getUserIdAttribute() + "\nGroup restriction: " + this.ldapConfiguration.getRestriction() + "\nconnectionTimeout: " + this.ldapConfiguration.getConnectionTimeout() + "\nreadTimeout: " + this.ldapConfiguration.getReadTimeout());
        }
        LDAPConnectionOptions connectionOptions = new LDAPConnectionOptions();
        connectionOptions.setConnectTimeoutMillis(this.ldapConfiguration.getConnectionTimeout());
        connectionOptions.setResponseTimeoutMillis((long)this.ldapConfiguration.getReadTimeout());
        URI uri = new URI(this.ldapConfiguration.getLdapHost());
        SocketFactory socketFactory = this.supportLDAPS(uri);
        LDAPConnection ldapConnection = new LDAPConnection(socketFactory, connectionOptions, uri.getHost(), uri.getPort(), this.ldapConfiguration.getPrincipal(), this.ldapConfiguration.getCredentials());
        this.ldapConnectionPool = new LDAPConnectionPool(ldapConnection, 4);
        this.ldapConnectionPool.setRetryFailedOperationsDueToInvalidConnections(true);
        this.userExtraFilter = Optional.ofNullable(this.ldapConfiguration.getFilter()).map(Throwing.function(Filter::create).sneakyThrow());
        this.objectClassFilter = Filter.createEqualityFilter((String)"objectClass", (String)this.ldapConfiguration.getUserObjectClass());
        this.listingFilter = this.userExtraFilter.map(extraFilter -> Filter.createANDFilter((Filter[])new Filter[]{this.objectClassFilter, extraFilter})).orElse(this.objectClassFilter);
        if (!this.ldapConfiguration.getPerDomainBaseDN().isEmpty()) {
            Preconditions.checkState((boolean)this.ldapConfiguration.supportsVirtualHosting(), (Object)"'virtualHosting' is needed for per domain DNs");
        }
    }

    private SocketFactory supportLDAPS(URI uri) throws KeyManagementException, NoSuchAlgorithmException {
        if (uri.getScheme().equals("ldaps")) {
            if (this.ldapConfiguration.isTrustAllCerts()) {
                SSLContext context = SSLContext.getInstance("TLSv1.2");
                context.init(null, new TrustManager[]{DUMMY_TRUST_MANAGER}, null);
                return context.getSocketFactory();
            }
            return SSLSocketFactory.getDefault();
        }
        return null;
    }

    @PreDestroy
    void dispose() {
        this.ldapConnectionPool.close();
    }

    private Filter createFilter(String username) {
        Filter specificUserFilter = Filter.createEqualityFilter((String)this.ldapConfiguration.getUserIdAttribute(), (String)username);
        return this.userExtraFilter.map(extraFilter -> Filter.createANDFilter((Filter[])new Filter[]{this.objectClassFilter, specificUserFilter, extraFilter})).orElseGet(() -> Filter.createANDFilter((Filter[])new Filter[]{this.objectClassFilter, specificUserFilter}));
    }

    private boolean userInGroupsMembershipList(DN userDN, Map<String, Collection<DN>> groupMembershipList) {
        boolean result = false;
        Collection<Collection<DN>> memberLists = groupMembershipList.values();
        Iterator<Collection<DN>> memberListsIterator = memberLists.iterator();
        while (memberListsIterator.hasNext() && !result) {
            Collection<DN> groupMembers = memberListsIterator.next();
            result = groupMembers.contains(userDN);
        }
        return result;
    }

    private String userBase(Domain domain) {
        return (String)this.ldapConfiguration.getPerDomainBaseDN().getOrDefault((Object)domain, (Object)this.ldapConfiguration.getUserBase());
    }

    private String userBase(Username username) {
        return username.getDomainPart().map(this::userBase).orElse(this.ldapConfiguration.getUserBase());
    }

    private Set<DN> getAllUsersDNFromLDAP() throws LDAPException {
        return (Set)this.allDNs().flatMap(Throwing.function(this::entriesFromDN).sneakyThrow()).map(Throwing.function(Entry::getParsedDN)).collect(ImmutableSet.toImmutableSet());
    }

    private Stream<String> allDNs() {
        return Stream.concat(Stream.of(this.ldapConfiguration.getUserBase()), this.ldapConfiguration.getPerDomainBaseDN().values().stream());
    }

    private Stream<SearchResultEntry> entriesFromDN(String dn) throws LDAPSearchException {
        return this.entriesFromDN(dn, "1.1");
    }

    private Stream<SearchResultEntry> entriesFromDN(String dn, String attributes) throws LDAPSearchException {
        SearchRequest searchRequest = new SearchRequest(dn, SearchScope.SUB, this.listingFilter, new String[]{attributes});
        return this.ldapConnectionPool.search(searchRequest).getSearchEntries().stream();
    }

    private Stream<Username> getAllUsernamesFromLDAP() throws LDAPException {
        return this.allDNs().flatMap(Throwing.function(s -> this.entriesFromDN((String)s, this.ldapConfiguration.getUserIdAttribute())).sneakyThrow()).flatMap(entry -> Optional.ofNullable(entry.getAttribute(this.ldapConfiguration.getUserIdAttribute())).stream()).map(Attribute::getValue).map(Username::of);
    }

    private Collection<ReadOnlyLDAPUser> buildUserCollection(Collection<DN> userDNs) throws LDAPException {
        ArrayList<ReadOnlyLDAPUser> results = new ArrayList<ReadOnlyLDAPUser>();
        for (DN userDN : userDNs) {
            Optional<ReadOnlyLDAPUser> user = this.buildUser(userDN);
            user.ifPresent(results::add);
        }
        return results;
    }

    private Optional<ReadOnlyLDAPUser> searchAndBuildUser(Username name) throws LDAPException {
        SearchResult searchResult = this.ldapConnectionPool.search(this.userBase(name), SearchScope.SUB, this.createFilter(name.asString()), new String[]{this.ldapConfiguration.getUserIdAttribute()});
        SearchResultEntry result = searchResult.getSearchEntries().stream().findFirst().orElse(null);
        if (result == null) {
            return Optional.empty();
        }
        if (!this.ldapConfiguration.getRestriction().isActivated() || this.userInGroupsMembershipList(result.getParsedDN(), this.ldapConfiguration.getRestriction().getGroupMembershipLists(this.ldapConnectionPool))) {
            return Optional.of(new ReadOnlyLDAPUser(name, result.getParsedDN(), this.ldapConnectionPool));
        }
        return Optional.empty();
    }

    private Optional<ReadOnlyLDAPUser> buildUser(DN userDN) throws LDAPException {
        SearchResultEntry userAttributes = this.ldapConnectionPool.getEntry(userDN.toString());
        Optional<String> userName = Optional.ofNullable(userAttributes.getAttributeValue(this.ldapConfiguration.getUserIdAttribute()));
        return userName.map(Username::of).map(username -> new ReadOnlyLDAPUser((Username)username, userDN, this.ldapConnectionPool));
    }

    public boolean contains(Username name) throws UsersRepositoryException {
        return this.getUserByName(name).isPresent();
    }

    public int countUsers() throws UsersRepositoryException {
        try {
            return Math.toIntExact(this.doCountUsers());
        }
        catch (LDAPException e) {
            throw new UsersRepositoryException("Unable to retrieve user count from ldap", (Throwable)e);
        }
    }

    private long doCountUsers() throws LDAPException {
        if (!this.ldapConfiguration.getRestriction().isActivated()) {
            return this.getAllUsernamesFromLDAP().count();
        }
        return this.getValidUserDNs().stream().map(Throwing.function(this::buildUser).sneakyThrow()).flatMap(Optional::stream).count();
    }

    public Optional<ReadOnlyLDAPUser> getUserByName(Username name) throws UsersRepositoryException {
        try {
            return this.searchAndBuildUser(name);
        }
        catch (Exception e) {
            throw new UsersRepositoryException("Unable check user existence from ldap", (Throwable)e);
        }
    }

    public Iterator<Username> list() throws UsersRepositoryException {
        try {
            if (!this.ldapConfiguration.getRestriction().isActivated()) {
                return this.getAllUsernamesFromLDAP().iterator();
            }
            return this.buildUserCollection(this.getValidUserDNs()).stream().map(ReadOnlyLDAPUser::getUserName).iterator();
        }
        catch (LDAPException e) {
            throw new UsersRepositoryException("Unable to list users from ldap", (Throwable)e);
        }
    }

    private Collection<DN> getValidUserDNs() throws LDAPException {
        Collection<Object> validUserDNs;
        Set<DN> userDNs = this.getAllUsersDNFromLDAP();
        if (this.ldapConfiguration.getRestriction().isActivated()) {
            Map<String, Collection<DN>> groupMembershipList = this.ldapConfiguration.getRestriction().getGroupMembershipLists(this.ldapConnectionPool);
            validUserDNs = new ArrayList();
            for (DN userDN : userDNs) {
                if (!this.userInGroupsMembershipList(userDN, groupMembershipList)) continue;
                validUserDNs.add(userDN);
            }
        } else {
            validUserDNs = userDNs;
        }
        return validUserDNs;
    }

    public void removeUser(Username name) throws UsersRepositoryException {
        throw new UsersRepositoryException("This user-repository is read-only. Modifications are not permitted.");
    }

    public void updateUser(User user) throws UsersRepositoryException {
        throw new UsersRepositoryException("This user-repository is read-only. Modifications are not permitted.");
    }

    public void addUser(Username username, String password) throws UsersRepositoryException {
        throw new UsersRepositoryException("This user-repository is read-only. Modifications are not permitted.");
    }
}

