/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs;

import com.unboundid.ldap.sdk.unboundidds.logs.ErrorLogCategory;
import com.unboundid.ldap.sdk.unboundidds.logs.ErrorLogSeverity;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.LogMessage;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ErrorLogMessage
extends LogMessage {
    private static final long serialVersionUID = 1743586990943392442L;
    @Nullable
    private final ErrorLogCategory category;
    @Nullable
    private final ErrorLogSeverity severity;
    @Nullable
    private final Long messageID;
    @Nullable
    private final Long triggeredByConnectionID;
    @Nullable
    private final Long triggeredByOperationID;
    @Nullable
    private final String instanceName;
    @Nullable
    private final String message;
    @Nullable
    private final String productName = this.getNamedValue("product");
    @Nullable
    private final String startupID;

    public ErrorLogMessage(@NotNull String s) throws LogException {
        this(new LogMessage(s));
    }

    public ErrorLogMessage(@NotNull LogMessage m) {
        super(m);
        this.instanceName = this.getNamedValue("instanceName");
        this.startupID = this.getNamedValue("startupID");
        this.messageID = this.getNamedValueAsLong("msgID");
        this.message = this.getNamedValue("msg");
        this.triggeredByConnectionID = this.getNamedValueAsLong("triggeredByConn");
        this.triggeredByOperationID = this.getNamedValueAsLong("triggeredByOp");
        ErrorLogCategory cat = null;
        try {
            cat = ErrorLogCategory.valueOf(this.getNamedValue("category"));
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        this.category = cat;
        ErrorLogSeverity sev = null;
        try {
            sev = ErrorLogSeverity.valueOf(this.getNamedValue("severity"));
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        this.severity = sev;
    }

    @Nullable
    public String getProductName() {
        return this.productName;
    }

    @Nullable
    public String getInstanceName() {
        return this.instanceName;
    }

    @Nullable
    public String getStartupID() {
        return this.startupID;
    }

    @Nullable
    public ErrorLogCategory getCategory() {
        return this.category;
    }

    @Nullable
    public ErrorLogSeverity getSeverity() {
        return this.severity;
    }

    @Nullable
    public Long getMessageID() {
        return this.messageID;
    }

    @Nullable
    public Long getTriggeredByConnectionID() {
        return this.triggeredByConnectionID;
    }

    @Nullable
    public Long getTriggeredByOperationID() {
        return this.triggeredByOperationID;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }
}

