/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MailboxUtil;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.UidValidity;

public class Mailbox {
    private final MailboxId id;
    private MailboxPath path;
    private final UidValidity uidValidity;
    private MailboxACL acl = MailboxACL.EMPTY;

    public Mailbox(MailboxPath path, UidValidity uidValidity, MailboxId mailboxId) {
        this.id = mailboxId;
        this.path = path;
        this.uidValidity = uidValidity;
    }

    public Mailbox(Mailbox mailbox) {
        this.id = mailbox.getMailboxId();
        this.path = mailbox.generateAssociatedPath();
        this.uidValidity = mailbox.getUidValidity();
        this.acl = new MailboxACL(mailbox.getACL().getEntries());
    }

    public MailboxId getMailboxId() {
        return this.id;
    }

    public String getNamespace() {
        return this.path.getNamespace();
    }

    public void setNamespace(String namespace) {
        this.path = new MailboxPath(namespace, this.path.getUser(), this.path.getName());
    }

    public Username getUser() {
        return this.path.getUser();
    }

    public void setUser(Username user) {
        this.path = new MailboxPath(this.path.getNamespace(), user, this.path.getName());
    }

    public String getName() {
        return this.path.getName();
    }

    public void setName(String name) {
        this.path = new MailboxPath(this.path.getNamespace(), this.path.getUser(), name);
    }

    public UidValidity getUidValidity() {
        return this.uidValidity;
    }

    public MailboxPath generateAssociatedPath() {
        return this.path;
    }

    public MailboxACL getACL() {
        return this.acl;
    }

    public void setACL(MailboxACL acl) {
        this.acl = acl;
    }

    public boolean isChildOf(Mailbox potentialParent, MailboxSession mailboxSession) {
        return MailboxUtil.isMailboxChildOf(this, potentialParent, mailboxSession);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Mailbox) {
            Mailbox o = (Mailbox)obj;
            return Objects.equals(this.id, o.getMailboxId());
        }
        return false;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getMailboxId().serialize()).add("namespace", (Object)this.path.getNamespace()).add("user", (Object)this.path.getUser()).add("name", (Object)this.path.getName()).toString();
    }
}

