/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.james.AggregateUserEntityValidator;
import org.apache.james.core.Username;

public interface UserEntityValidator {
    public static final UserEntityValidator NOOP = (username, ignoredTypes) -> Optional.empty();

    public static UserEntityValidator aggregate(UserEntityValidator ... validators) {
        return new AggregateUserEntityValidator((Set<UserEntityValidator>)ImmutableSet.copyOf((Object[])validators));
    }

    public Optional<ValidationFailure> canCreate(Username var1, Set<EntityType> var2) throws Exception;

    default public Optional<ValidationFailure> canCreate(Username username) throws Exception {
        return this.canCreate(username, (Set<EntityType>)ImmutableSet.of());
    }

    public static class EntityType {
        public static final EntityType GROUP = new EntityType("group");
        public static final EntityType ALIAS = new EntityType("alias");
        public static final EntityType USER = new EntityType("user");
        private final String type;

        public EntityType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public int hashCode() {
            return Objects.hash(this.type);
        }

        public boolean equals(Object obj) {
            if (obj instanceof EntityType) {
                EntityType other = (EntityType)obj;
                return Objects.equals(this.type, other.type);
            }
            return false;
        }
    }

    public static class ValidationFailure {
        private final String errorMessage;

        public ValidationFailure(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public String errorMessage() {
            return this.errorMessage;
        }
    }
}

