/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.Analyzer;
import org.opensearch.client.opensearch._types.analysis.AnalyzerVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class CustomAnalyzer
implements AnalyzerVariant,
JsonpSerializable {
    private final List<String> charFilter;
    private final List<String> filter;
    @Nullable
    private final Integer positionIncrementGap;
    @Nullable
    private final Integer positionOffsetGap;
    private final String tokenizer;
    public static final JsonpDeserializer<CustomAnalyzer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CustomAnalyzer::setupCustomAnalyzerDeserializer);

    private CustomAnalyzer(Builder builder) {
        this.charFilter = ApiTypeHelper.unmodifiable(builder.charFilter);
        this.filter = ApiTypeHelper.unmodifiable(builder.filter);
        this.positionIncrementGap = builder.positionIncrementGap;
        this.positionOffsetGap = builder.positionOffsetGap;
        this.tokenizer = ApiTypeHelper.requireNonNull(builder.tokenizer, this, "tokenizer");
    }

    public static CustomAnalyzer of(Function<Builder, ObjectBuilder<CustomAnalyzer>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Analyzer.Kind _analyzerKind() {
        return Analyzer.Kind.Custom;
    }

    public final List<String> charFilter() {
        return this.charFilter;
    }

    public final List<String> filter() {
        return this.filter;
    }

    @Nullable
    public final Integer positionIncrementGap() {
        return this.positionIncrementGap;
    }

    @Nullable
    public final Integer positionOffsetGap() {
        return this.positionOffsetGap;
    }

    public final String tokenizer() {
        return this.tokenizer;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "custom");
        if (ApiTypeHelper.isDefined(this.charFilter)) {
            generator.writeKey("char_filter");
            generator.writeStartArray();
            for (String item0 : this.charFilter) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.filter)) {
            generator.writeKey("filter");
            generator.writeStartArray();
            for (String item0 : this.filter) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.positionIncrementGap != null) {
            generator.writeKey("position_increment_gap");
            generator.write(this.positionIncrementGap.intValue());
        }
        if (this.positionOffsetGap != null) {
            generator.writeKey("position_offset_gap");
            generator.write(this.positionOffsetGap.intValue());
        }
        generator.writeKey("tokenizer");
        generator.write(this.tokenizer);
    }

    protected static void setupCustomAnalyzerDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::charFilter, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "char_filter");
        op.add(Builder::filter, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "filter");
        op.add(Builder::positionIncrementGap, JsonpDeserializer.integerDeserializer(), "position_increment_gap");
        op.add(Builder::positionOffsetGap, JsonpDeserializer.integerDeserializer(), "position_offset_gap");
        op.add(Builder::tokenizer, JsonpDeserializer.stringDeserializer(), "tokenizer");
        op.ignore("type");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<CustomAnalyzer> {
        @Nullable
        private List<String> charFilter;
        @Nullable
        private List<String> filter;
        @Nullable
        private Integer positionIncrementGap;
        @Nullable
        private Integer positionOffsetGap;
        private String tokenizer;

        public final Builder charFilter(List<String> list) {
            this.charFilter = Builder._listAddAll(this.charFilter, list);
            return this;
        }

        public final Builder charFilter(String value, String ... values) {
            this.charFilter = Builder._listAdd(this.charFilter, value, values);
            return this;
        }

        public final Builder filter(List<String> list) {
            this.filter = Builder._listAddAll(this.filter, list);
            return this;
        }

        public final Builder filter(String value, String ... values) {
            this.filter = Builder._listAdd(this.filter, value, values);
            return this;
        }

        public final Builder positionIncrementGap(@Nullable Integer value) {
            this.positionIncrementGap = value;
            return this;
        }

        public final Builder positionOffsetGap(@Nullable Integer value) {
            this.positionOffsetGap = value;
            return this;
        }

        public final Builder tokenizer(String value) {
            this.tokenizer = value;
            return this;
        }

        @Override
        public CustomAnalyzer build() {
            this._checkSingleUse();
            return new CustomAnalyzer(this);
        }
    }
}

