/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import jakarta.json.bind.serializer.JsonbSerializer;
import jakarta.json.bind.serializer.SerializationContext;
import jakarta.json.stream.JsonGenerator;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.Marshaller;
import org.eclipse.yasson.internal.ProcessingContext;
import org.eclipse.yasson.internal.model.ClassModel;
import org.eclipse.yasson.internal.model.customization.Customization;
import org.eclipse.yasson.internal.serializer.CurrentItem;
import org.eclipse.yasson.internal.serializer.SerializerBuilder;

public class OptionalObjectSerializer<T extends Optional<?>>
implements CurrentItem<T>,
JsonbSerializer<T> {
    private final Customization customization;
    private final CurrentItem<?> wrapper;
    private final Type optionalValueType;

    public OptionalObjectSerializer(SerializerBuilder builder) {
        this.wrapper = builder.getWrapper();
        this.customization = builder.getCustomization();
        this.optionalValueType = this.resolveOptionalType(builder.getRuntimeType());
    }

    private Type resolveOptionalType(Type runtimeType) {
        if (runtimeType instanceof ParameterizedType) {
            return ((ParameterizedType)runtimeType).getActualTypeArguments()[0];
        }
        return Object.class;
    }

    @Override
    public ClassModel getClassModel() {
        return null;
    }

    @Override
    public CurrentItem<?> getWrapper() {
        return this.wrapper;
    }

    @Override
    public Type getRuntimeType() {
        return this.optionalValueType;
    }

    public Customization getCustomization() {
        return this.customization;
    }

    public void serialize(T obj, JsonGenerator generator, SerializationContext ctx) {
        JsonbContext jsonbContext = ((ProcessingContext)ctx).getJsonbContext();
        if (OptionalObjectSerializer.handleEmpty(obj, Optional::isPresent, this.customization, generator, (Marshaller)ctx)) {
            return;
        }
        Object optionalValue = ((Optional)obj).get();
        JsonbSerializer<?> serializer = ((SerializerBuilder)((SerializerBuilder)((SerializerBuilder)new SerializerBuilder(jsonbContext).withObjectClass(optionalValue.getClass()).withType(this.optionalValueType)).withWrapper(this.wrapper)).withCustomization(this.customization)).build();
        this.serialCaptor(serializer, optionalValue, generator, ctx);
    }

    static <T> boolean handleEmpty(T value, Predicate<T> presentCheck, Customization customization, JsonGenerator generator, Marshaller marshaller) {
        if (value == null || !presentCheck.test(value)) {
            if (customization != null) {
                if (customization.isNillable()) {
                    generator.writeNull();
                    return true;
                }
            } else {
                marshaller.getJsonbContext().getConfigProperties().getNullSerializer().serialize(value, generator, (SerializationContext)marshaller);
            }
            return true;
        }
        return false;
    }

    private <T> void serialCaptor(JsonbSerializer<?> serializer, T object, JsonGenerator generator, SerializationContext context) {
        serializer.serialize(object, generator, context);
    }
}

