/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema.events;

import com.datastax.oss.driver.api.core.metadata.schema.AggregateMetadata;
import com.datastax.oss.driver.internal.core.metadata.schema.SchemaChangeType;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class AggregateChangeEvent {
    public final SchemaChangeType changeType;
    public final AggregateMetadata oldAggregate;
    public final AggregateMetadata newAggregate;

    public static AggregateChangeEvent dropped(AggregateMetadata oldAggregate) {
        return new AggregateChangeEvent(SchemaChangeType.DROPPED, oldAggregate, null);
    }

    public static AggregateChangeEvent created(AggregateMetadata newAggregate) {
        return new AggregateChangeEvent(SchemaChangeType.CREATED, null, newAggregate);
    }

    public static AggregateChangeEvent updated(AggregateMetadata oldAggregate, AggregateMetadata newAggregate) {
        return new AggregateChangeEvent(SchemaChangeType.UPDATED, oldAggregate, newAggregate);
    }

    private AggregateChangeEvent(SchemaChangeType changeType, AggregateMetadata oldAggregate, AggregateMetadata newAggregate) {
        this.changeType = changeType;
        this.oldAggregate = oldAggregate;
        this.newAggregate = newAggregate;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof AggregateChangeEvent) {
            AggregateChangeEvent that = (AggregateChangeEvent)other;
            return this.changeType == that.changeType && Objects.equals(this.oldAggregate, that.oldAggregate) && Objects.equals(this.newAggregate, that.newAggregate);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.changeType, this.oldAggregate, this.newAggregate});
    }

    public String toString() {
        switch (this.changeType) {
            case CREATED: {
                return String.format("AggregateChangeEvent(CREATED %s)", this.newAggregate.getSignature());
            }
            case UPDATED: {
                return String.format("AggregateChangeEvent(UPDATED %s=>%s)", this.oldAggregate.getSignature(), this.newAggregate.getSignature());
            }
            case DROPPED: {
                return String.format("AggregateChangeEvent(DROPPED %s)", this.oldAggregate.getSignature());
            }
        }
        throw new IllegalStateException("Unsupported change type " + (Object)((Object)this.changeType));
    }
}

